/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;

public abstract class BaseExpression
extends Expression {
    protected Expression baseExpression;
    protected ExpressionBuilder builder;

    public BaseExpression() {
    }

    public BaseExpression(Expression baseExpression) {
        this.baseExpression = baseExpression;
    }

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    @Override
    public ExpressionBuilder getBuilder() {
        if (this.builder == null && this.baseExpression != null) {
            this.builder = this.baseExpression.getBuilder();
        }
        return this.builder;
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.baseExpression != null) {
            this.setBaseExpression(this.baseExpression.copiedVersionFrom(alreadyDone));
        }
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        if (this.baseExpression != null) {
            this.baseExpression.resetPlaceHolderBuilder(queryBuilder);
        }
    }

    public void setBaseExpression(Expression baseExpression) {
        this.baseExpression = baseExpression;
        this.builder = null;
    }

    @Override
    public Expression shallowClone() {
        BaseExpression clone2 = (BaseExpression)super.shallowClone();
        clone2.builder = null;
        return clone2;
    }
}

