/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class IndexedInteraction
extends EISInteraction {
    public void addArgument(String argumentFieldName) {
        this.getArguments().addElement(new DatabaseField(argumentFieldName));
    }

    public void addArgumentValue(Object argumentValue) {
        this.getArguments().addElement(argumentValue);
    }

    @Override
    public void addOutputArgument(String argumentFieldName) {
        this.getOutputArguments().addElement(new DatabaseField(argumentFieldName));
    }

    @Override
    public Vector getArguments() {
        return super.getArguments();
    }

    @Override
    public Vector getOutputArguments() {
        return super.getOutputArguments();
    }

    @Override
    public void setArguments(Vector arguments) {
        super.setArguments(arguments);
    }

    @Override
    public void setOutputArguments(Vector outputArguments) {
        super.setOutputArguments(outputArguments);
    }

    @Override
    public Record createInputRecord(EISAccessor accessor) {
        try {
            IndexedRecord record = accessor.getRecordFactory().createIndexedRecord(this.getInputRecordName());
            int index2 = 0;
            while (index2 < this.getParameters().size()) {
                Object parameter = this.getParameters().get(index2);
                record.add(this.createRecordElement("", parameter, accessor));
                ++index2;
            }
            return record;
        }
        catch (ResourceException exception) {
            throw EISException.resourceException(exception, accessor, null);
        }
    }

    @Override
    public AbstractRecord buildRow(Record record, EISAccessor accessor) {
        AbstractRecord row = null;
        if (record instanceof IndexedRecord) {
            IndexedRecord indexedRecord = (IndexedRecord)record;
            row = new DatabaseRecord(indexedRecord.size());
            int index2 = 0;
            while (index2 < indexedRecord.size()) {
                DatabaseField field2 = (DatabaseField)this.getOutputArguments().get(index2);
                row.put(field2, indexedRecord.get(index2));
                ++index2;
            }
        } else if (record instanceof MappedRecord) {
            MappedRecord mappedRecord = (MappedRecord)record;
            if (this.getOutputArgumentNames().size() == 1) {
                mappedRecord = (MappedRecord)mappedRecord.get(this.getOutputArgumentNames().get(0));
            } else if (this.getOutputArgumentNames().size() > 1) {
                row = new DatabaseRecord(this.getOutputArgumentNames().size());
                int index3 = 0;
                while (index3 < this.getOutputArgumentNames().size()) {
                    DatabaseField field3 = (DatabaseField)this.getOutputArguments().get(index3);
                    row.put(field3, mappedRecord.get(this.getOutputArgumentNames().get(index3)));
                    ++index3;
                }
                return row;
            }
            row = new EISMappedRecord((Map)mappedRecord, accessor);
        } else {
            row = new DatabaseRecord(1);
            row.put(this.getOutputResultPath(), (Object)record);
        }
        return row;
    }
}

