/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.TopicConfigManager$;
import kafka.server.TopicConfigManager$ConfigChangeListener$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\t\u0001B_6DY&,g\u000e^\u000b\u0002/A\u0011\u0001dH\u0007\u00023)\u0011!dG\u0001\tu.\u001cG.[3oi*\u0011A$H\u0001\u0007\u0013BJE/Z2\u000b\u0003y\t1a\u001c:h\u0013\t\u0001\u0013D\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011!\u0011\u0003A!A!\u0002\u00139\u0012!\u0003>l\u00072LWM\u001c;!\u0011!!\u0003A!b\u0001\n\u0013)\u0013A\u00037pO6\u000bg.Y4feV\ta\u0005\u0005\u0002(U5\t\u0001F\u0003\u0002*\t\u0005\u0019An\\4\n\u0005-B#A\u0003'pO6\u000bg.Y4fe\"AQ\u0006\u0001B\u0001B\u0003%a%A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002%\rD\u0017M\\4f\u000bb\u0004\u0018N]1uS>tWj]\u000b\u0002cA\u0011\u0011BM\u0005\u0003g)\u0011A\u0001T8oO\"AQ\u0007\u0001B\u0001B\u0003%\u0011'A\ndQ\u0006tw-Z#ya&\u0014\u0018\r^5p]6\u001b\b\u0005\u0003\u00058\u0001\t\u0015\r\u0011\"\u00039\u0003\u0011!\u0018.\\3\u0016\u0003e\u0002\"a\u0004\u001e\n\u0005m\u0002\"\u0001\u0002+j[\u0016D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0006i&lW\r\t\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u001bE)\u0012$\u0011\u0005\t\u0003Q\"\u0001\u0002\t\u000bUq\u0004\u0019A\f\t\u000b\u0011r\u0004\u0019\u0001\u0014\t\u000f=r\u0004\u0013!a\u0001c!9qG\u0010I\u0001\u0002\u0004I\u0004b\u0002%\u0001\u0001\u0004%I\u0001M\u0001\u0013Y\u0006\u001cH/\u0012=fGV$X\rZ\"iC:<W\rC\u0004K\u0001\u0001\u0007I\u0011B&\u0002-1\f7\u000f^#yK\u000e,H/\u001a3DQ\u0006tw-Z0%KF$\"\u0001T(\u0011\u0005%i\u0015B\u0001(\u000b\u0005\u0011)f.\u001b;\t\u000fAK\u0015\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\t\rI\u0003\u0001\u0015)\u00032\u0003Ma\u0017m\u001d;Fq\u0016\u001cW\u000f^3e\u0007\"\fgnZ3!\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u001d\u0019H/\u0019:ukB$\u0012\u0001\u0014\u0005\u0006/\u0002!I!V\u0001\u0018aJ|7-Z:t\u00032d7i\u001c8gS\u001e\u001c\u0005.\u00198hKNDQ!\u0017\u0001\u0005\ni\u000bA\u0003\u001d:pG\u0016\u001c8oQ8oM&<7\t[1oO\u0016\u001cHC\u0001'\\\u0011\u0015a\u0006\f1\u0001^\u00035qw\u000e^5gS\u000e\fG/[8ogB\u0019a,Y2\u000e\u0003}S!\u0001\u0019\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c?\n\u00191+Z9\u0011\u0005\u0011<gBA\u0005f\u0013\t1'\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u000b\u0011\u0015Y\u0007\u0001\"\u0003m\u00031\u0019\u0007.\u00198hK:+XNY3s)\t\tT\u000eC\u0003oU\u0002\u00071-\u0001\u0003oC6,w!\u00029\u0001\u0011\u0003\t\u0018\u0001F\"p]\u001aLwm\u00115b]\u001e,G*[:uK:,'\u000f\u0005\u0002sg6\t\u0001AB\u0003u\u0001!\u0005QO\u0001\u000bD_:4\u0017nZ\"iC:<W\rT5ti\u0016tWM]\n\u0004gZt\bCA<}\u001b\u0005A(BA={\u0003\u0011a\u0017M\\4\u000b\u0003m\fAA[1wC&\u0011Q\u0010\u001f\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005ay\u0018bAA\u00013\t\u0001\u0012JW6DQ&dG\rT5ti\u0016tWM\u001d\u0005\u0007\u007fM$\t!!\u0002\u0015\u0003EDq!!\u0003t\t\u0003\nY!A\tiC:$G.Z\"iS2$7\t[1oO\u0016$R\u0001TA\u0007\u0003#Aq!a\u0004\u0002\b\u0001\u00071-\u0001\u0003qCRD\u0007\u0002CA\n\u0003\u000f\u0001\r!!\u0006\u0002\u0011\rD\u0017\u000e\u001c7j]N\u0004R!a\u0006\u0002\u001e\rl!!!\u0007\u000b\u0007\u0005m!0\u0001\u0003vi&d\u0017\u0002BA\u0010\u00033\u0011A\u0001T5ti\u001eI\u00111\u0005\u0002\u0002\u0002#\u0005\u0011QE\u0001\u0013)>\u0004\u0018nY\"p]\u001aLw-T1oC\u001e,'\u000fE\u0002C\u0003O1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011F\n\u0004\u0003OA\u0001bB \u0002(\u0011\u0005\u0011Q\u0006\u000b\u0003\u0003KA!\"!\r\u0002(E\u0005I\u0011AA\u001a\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0007\u0016\u0004c\u0005]2FAA\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r#\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002>\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005-\u0013qEI\u0001\n\u0003\ti%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001fR3!OA\u001c\u0001")
public class TopicConfigManager
implements Logging {
    private final ZkClient kafka$server$TopicConfigManager$$zkClient;
    private final LogManager kafka$server$TopicConfigManager$$logManager;
    private final long kafka$server$TopicConfigManager$$changeExpirationMs;
    private final Time time;
    private long kafka$server$TopicConfigManager$$lastExecutedChange;
    private volatile TopicConfigManager$ConfigChangeListener$ ConfigChangeListener$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return TopicConfigManager$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return TopicConfigManager$.MODULE$.$lessinit$greater$default$3();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TopicConfigManager$ConfigChangeListener$ ConfigChangeListener$lzycompute() {
        TopicConfigManager topicConfigManager = this;
        synchronized (topicConfigManager) {
            if (this.ConfigChangeListener$module != null) return this.ConfigChangeListener$module;
            this.ConfigChangeListener$module = new TopicConfigManager$ConfigChangeListener$(this);
            return this.ConfigChangeListener$module;
        }
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicConfigManager topicConfigManager = this;
        synchronized (topicConfigManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ZkClient kafka$server$TopicConfigManager$$zkClient() {
        return this.kafka$server$TopicConfigManager$$zkClient;
    }

    public LogManager kafka$server$TopicConfigManager$$logManager() {
        return this.kafka$server$TopicConfigManager$$logManager;
    }

    public long kafka$server$TopicConfigManager$$changeExpirationMs() {
        return this.kafka$server$TopicConfigManager$$changeExpirationMs;
    }

    private Time time() {
        return this.time;
    }

    public long kafka$server$TopicConfigManager$$lastExecutedChange() {
        return this.kafka$server$TopicConfigManager$$lastExecutedChange;
    }

    public void kafka$server$TopicConfigManager$$lastExecutedChange_$eq(long x$1) {
        this.kafka$server$TopicConfigManager$$lastExecutedChange = x$1;
    }

    public void startup() {
        ZkUtils$.MODULE$.makeSurePersistentPathExists(this.kafka$server$TopicConfigManager$$zkClient(), ZkUtils$.MODULE$.TopicConfigChangesPath());
        this.kafka$server$TopicConfigManager$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.TopicConfigChangesPath(), this.ConfigChangeListener());
        this.processAllConfigChanges();
    }

    private void processAllConfigChanges() {
        List<String> configChanges = this.kafka$server$TopicConfigManager$$zkClient().getChildren(ZkUtils$.MODULE$.TopicConfigChangesPath());
        this.kafka$server$TopicConfigManager$$processConfigChanges((Seq)JavaConversions$.MODULE$.asScalaBuffer(configChanges).sorted(Ordering$String$.MODULE$));
    }

    public void kafka$server$TopicConfigManager$$processConfigChanges(Seq<String> notifications) {
        if (notifications.size() > 0) {
            this.info((Function0<String>)((Object)new scala.Serializable(this, notifications){
                public static final long serialVersionUID = 0L;
                private final Seq notifications$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Processing %d topic config change notification(s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.notifications$1.size())}));
                }
                {
                    this.notifications$1 = notifications$1;
                }
            }));
            long now = this.time().milliseconds();
            Buffer logs = this.kafka$server$TopicConfigManager$$logManager().logsByTopicPartition().toBuffer();
            Map logsByTopic = logs.groupBy(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, Log> x$1) {
                    return x$1._1().topic();
                }
            }).mapValues(new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Buffer<Log> apply(Buffer<Tuple2<TopicAndPartition, Log>> x$2) {
                    return x$2.map(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Log apply(Tuple2<TopicAndPartition, Log> x$3) {
                            return x$3._2();
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                }
            });
            notifications.foreach(new scala.Serializable(this, now, logsByTopic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigManager $outer;
                private final long now$1;
                private final Map logsByTopic$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object apply(String notification) {
                    Serializable serializable2;
                    long changeId = this.$outer.kafka$server$TopicConfigManager$$changeNumber(notification);
                    if (changeId > this.$outer.kafka$server$TopicConfigManager$$lastExecutedChange()) {
                        Tuple2<String, Stat> tuple2;
                        String changeZnode = new StringBuilder().append((Object)ZkUtils$.MODULE$.TopicConfigChangesPath()).append((Object)"/").append((Object)notification).toString();
                        Tuple2<String, Stat> tuple22 = ZkUtils$.MODULE$.readData(this.$outer.kafka$server$TopicConfigManager$$zkClient(), changeZnode);
                        if (tuple22 == null) throw new MatchError(tuple22);
                        String topicJson = tuple22._1();
                        Stat stat = tuple22._2();
                        Tuple2<String, Stat> tuple23 = tuple2 = new Tuple2<String, Stat>(topicJson, stat);
                        String topicJson2 = tuple23._1();
                        Stat stat2 = tuple23._2();
                        String topic = topicJson2.substring(1, topicJson2.length() - 1);
                        if (this.logsByTopic$1.contains(topic)) {
                            Properties props = new Properties(this.$outer.kafka$server$TopicConfigManager$$logManager().defaultConfig().toProps());
                            ((Hashtable)props).putAll(AdminUtils$.MODULE$.fetchTopicConfig(this.$outer.kafka$server$TopicConfigManager$$zkClient(), topic));
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(props);
                            ((IterableLike)this.logsByTopic$1.apply(topic)).foreach(new scala.Serializable(this, logConfig){
                                public static final long serialVersionUID = 0L;
                                private final LogConfig logConfig$1;

                                public final void apply(Log log2) {
                                    log2.config_$eq(this.logConfig$1);
                                }
                                {
                                    this.logConfig$1 = logConfig$1;
                                }
                            });
                            this.$outer.kafka$server$TopicConfigManager$$lastExecutedChange_$eq(changeId);
                            this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, changeId, topic, props){
                                public static final long serialVersionUID = 0L;
                                private final long changeId$1;
                                private final String topic$1;
                                private final Properties props$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Processed topic config change %d for topic %s, setting new config to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.changeId$1), this.topic$1, this.props$1}));
                                }
                                {
                                    this.changeId$1 = changeId$1;
                                    this.topic$1 = topic$1;
                                    this.props$1 = props$1;
                                }
                            }));
                            serializable2 = BoxedUnit.UNIT;
                            return serializable2;
                        } else {
                            if (this.now$1 - stat2.getCtime() > this.$outer.kafka$server$TopicConfigManager$$changeExpirationMs()) {
                                this.$outer.error((Function0<String>)((Object)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Ignoring topic config change %d for topic %s since the change has expired";
                                    }
                                }));
                            } else {
                                this.$outer.error((Function0<String>)((Object)new scala.Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Ignoring topic config change %d for topic %s since the topic may have been deleted";
                                    }
                                }));
                            }
                            serializable2 = BoxesRunTime.boxToBoolean(ZkUtils$.MODULE$.deletePath(this.$outer.kafka$server$TopicConfigManager$$zkClient(), changeZnode));
                        }
                        return serializable2;
                    } else {
                        serializable2 = BoxedUnit.UNIT;
                    }
                    return serializable2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.now$1 = now$1;
                    this.logsByTopic$1 = logsByTopic$1;
                }
            });
        }
    }

    public long kafka$server$TopicConfigManager$$changeNumber(String name) {
        return new StringOps(Predef$.MODULE$.augmentString(name.substring(AdminUtils$.MODULE$.TopicConfigChangeZnodePrefix().length()))).toLong();
    }

    public TopicConfigManager$ConfigChangeListener$ ConfigChangeListener() {
        return this.ConfigChangeListener$module == null ? this.ConfigChangeListener$lzycompute() : this.ConfigChangeListener$module;
    }

    public TopicConfigManager(ZkClient zkClient, LogManager logManager, long changeExpirationMs, Time time) {
        this.kafka$server$TopicConfigManager$$zkClient = zkClient;
        this.kafka$server$TopicConfigManager$$logManager = logManager;
        this.kafka$server$TopicConfigManager$$changeExpirationMs = changeExpirationMs;
        this.time = time;
        Logging$class.$init$(this);
        this.kafka$server$TopicConfigManager$$lastExecutedChange = -1L;
    }
}

