/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractUnsafeSwappedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;

final class UnsafeHeapSwappedByteBuf
extends AbstractUnsafeSwappedByteBuf {
    UnsafeHeapSwappedByteBuf(AbstractByteBuf buf) {
        super(buf);
    }

    private static int idx(ByteBuf wrapped, int index2) {
        return wrapped.arrayOffset() + index2;
    }

    @Override
    protected long _getLong(AbstractByteBuf wrapped, int index2) {
        return PlatformDependent.getLong(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2));
    }

    @Override
    protected int _getInt(AbstractByteBuf wrapped, int index2) {
        return PlatformDependent.getInt(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2));
    }

    @Override
    protected short _getShort(AbstractByteBuf wrapped, int index2) {
        return PlatformDependent.getShort(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2));
    }

    @Override
    protected void _setShort(AbstractByteBuf wrapped, int index2, short value2) {
        PlatformDependent.putShort(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2), value2);
    }

    @Override
    protected void _setInt(AbstractByteBuf wrapped, int index2, int value2) {
        PlatformDependent.putInt(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2), value2);
    }

    @Override
    protected void _setLong(AbstractByteBuf wrapped, int index2, long value2) {
        PlatformDependent.putLong(wrapped.array(), UnsafeHeapSwappedByteBuf.idx(wrapped, index2), value2);
    }
}

