/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.buffer.UnsafeHeapSwappedByteBuf;
import io.netty.util.internal.PlatformDependent;

final class UnpooledUnsafeHeapByteBuf
extends UnpooledHeapByteBuf {
    UnpooledUnsafeHeapByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    @Override
    public byte getByte(int index2) {
        this.checkIndex(index2);
        return this._getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return UnsafeByteBufUtil.getByte(this.array, index2);
    }

    @Override
    public short getShort(int index2) {
        this.checkIndex(index2, 2);
        return this._getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return UnsafeByteBufUtil.getShort(this.array, index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        this.checkIndex(index2, 3);
        return this._getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.array, index2);
    }

    @Override
    public int getInt(int index2) {
        this.checkIndex(index2, 4);
        return this._getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return UnsafeByteBufUtil.getInt(this.array, index2);
    }

    @Override
    public long getLong(int index2) {
        this.checkIndex(index2, 8);
        return this._getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return UnsafeByteBufUtil.getLong(this.array, index2);
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.checkIndex(index2);
        this._setByte(index2, value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        UnsafeByteBufUtil.setByte(this.array, index2, value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.checkIndex(index2, 2);
        this._setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        UnsafeByteBufUtil.setShort(this.array, index2, value2);
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.checkIndex(index2, 3);
        this._setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        UnsafeByteBufUtil.setMedium(this.array, index2, value2);
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.checkIndex(index2, 4);
        this._setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        UnsafeByteBufUtil.setInt(this.array, index2, value2);
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.checkIndex(index2, 8);
        this._setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        UnsafeByteBufUtil.setLong(this.array, index2, value2);
    }

    @Override
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

