/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class DuplicatedByteBuf
extends AbstractDerivedByteBuf {
    private final ByteBuf buffer;

    public DuplicatedByteBuf(ByteBuf buffer) {
        super(buffer.maxCapacity());
        this.buffer = buffer instanceof DuplicatedByteBuf ? ((DuplicatedByteBuf)buffer).buffer : buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
        this.markReaderIndex();
        this.markWriterIndex();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.buffer.capacity(newCapacity);
        return this;
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.buffer.hasMemoryAddress();
    }

    @Override
    public long memoryAddress() {
        return this.buffer.memoryAddress();
    }

    @Override
    public byte getByte(int index2) {
        return this.buffer.getByte(index2);
    }

    @Override
    protected byte _getByte(int index2) {
        return this.buffer.getByte(index2);
    }

    @Override
    public short getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    @Override
    protected short _getShort(int index2) {
        return this.buffer.getShort(index2);
    }

    @Override
    public int getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(index2);
    }

    @Override
    protected int _getUnsignedMedium(int index2) {
        return this.buffer.getUnsignedMedium(index2);
    }

    @Override
    public int getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    @Override
    protected int _getInt(int index2) {
        return this.buffer.getInt(index2);
    }

    @Override
    public long getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    @Override
    protected long _getLong(int index2) {
        return this.buffer.getLong(index2);
    }

    @Override
    public ByteBuf copy(int index2, int length) {
        return this.buffer.copy(index2, length);
    }

    @Override
    public ByteBuf slice(int index2, int length) {
        return this.buffer.slice(index2, length);
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuf dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index2, dst, dstIndex, length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, ByteBuffer dst) {
        this.buffer.getBytes(index2, dst);
        return this;
    }

    @Override
    public ByteBuf setByte(int index2, int value2) {
        this.buffer.setByte(index2, value2);
        return this;
    }

    @Override
    protected void _setByte(int index2, int value2) {
        this.buffer.setByte(index2, value2);
    }

    @Override
    public ByteBuf setShort(int index2, int value2) {
        this.buffer.setShort(index2, value2);
        return this;
    }

    @Override
    protected void _setShort(int index2, int value2) {
        this.buffer.setShort(index2, value2);
    }

    @Override
    public ByteBuf setMedium(int index2, int value2) {
        this.buffer.setMedium(index2, value2);
        return this;
    }

    @Override
    protected void _setMedium(int index2, int value2) {
        this.buffer.setMedium(index2, value2);
    }

    @Override
    public ByteBuf setInt(int index2, int value2) {
        this.buffer.setInt(index2, value2);
        return this;
    }

    @Override
    protected void _setInt(int index2, int value2) {
        this.buffer.setInt(index2, value2);
    }

    @Override
    public ByteBuf setLong(int index2, long value2) {
        this.buffer.setLong(index2, value2);
        return this;
    }

    @Override
    protected void _setLong(int index2, long value2) {
        this.buffer.setLong(index2, value2);
    }

    @Override
    public ByteBuf setBytes(int index2, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuf src, int srcIndex, int length) {
        this.buffer.setBytes(index2, src, srcIndex, length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int index2, ByteBuffer src) {
        this.buffer.setBytes(index2, src);
        return this;
    }

    @Override
    public ByteBuf getBytes(int index2, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index2, out, length);
        return this;
    }

    @Override
    public int getBytes(int index2, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index2, out, length);
    }

    @Override
    public int setBytes(int index2, InputStream in, int length) throws IOException {
        return this.buffer.setBytes(index2, in, length);
    }

    @Override
    public int setBytes(int index2, ScatteringByteChannel in, int length) throws IOException {
        return this.buffer.setBytes(index2, in, length);
    }

    @Override
    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index2, int length) {
        return this.buffer.nioBuffers(index2, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index2, int length) {
        return this.nioBuffer(index2, length);
    }

    @Override
    public int forEachByte(int index2, int length, ByteBufProcessor processor) {
        return this.buffer.forEachByte(index2, length, processor);
    }

    @Override
    public int forEachByteDesc(int index2, int length, ByteBufProcessor processor) {
        return this.buffer.forEachByteDesc(index2, length, processor);
    }
}

