/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.persistent.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.eaio.uuid.UUID;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.model.LocalId;
import eu.europeana.cloud.common.utils.Bucket;
import eu.europeana.cloud.service.commons.utils.BucketsHandler;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.status.IdentifierErrorTemplate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CassandraLocalIdDAO {
    private CassandraConnectionProvider dbService;
    private PreparedStatement insertStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement searchByProviderStatement;
    private PreparedStatement searchByRecordIdStatement;
    private PreparedStatement searchByProviderPaginatedStatement;
    private static final String PROVIDER_RECORD_ID_BUCKETS_TABLE = "provider_record_id_buckets";
    @Autowired
    private BucketsHandler bucketsHandler;

    public CassandraLocalIdDAO(CassandraConnectionProvider dbService) {
        this.dbService = dbService;
        this.prepareStatements();
    }

    private void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO Provider_Record_Id(provider_id,bucket_id, record_id,cloud_id) VALUES(?,?,?,?)");
        this.insertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteStatement = this.dbService.getSession().prepare("DELETE FROM Provider_Record_Id WHERE provider_id= ? AND bucket_id = ? AND record_Id= ?");
        this.deleteStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByProviderStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id = ? AND bucket_id = ?");
        this.searchByProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByRecordIdStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id=? AND bucket_id = ? AND record_id=?");
        this.searchByRecordIdStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByProviderPaginatedStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id=? AND bucket_id = ? AND record_id>=? LIMIT ?");
        this.searchByProviderPaginatedStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public List<CloudId> searchById(String ... args) throws DatabaseConnectionException {
        try {
            ResultSet rs = null;
            ArrayList<CloudId> result2 = new ArrayList<CloudId>();
            Bucket bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, args[0]);
            while (bucket != null) {
                if (args.length == 1) {
                    rs = this.dbService.getSession().execute(this.searchByProviderStatement.bind(args[0], java.util.UUID.fromString(bucket.getBucketId())));
                } else if (args.length >= 2) {
                    rs = this.dbService.getSession().execute(this.searchByRecordIdStatement.bind(args[0], java.util.UUID.fromString(bucket.getBucketId()), args[1]));
                }
                result2.addAll(this.createCloudIdsFromRs(rs));
                bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, args[0], bucket);
            }
            return result2;
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.dbService.getHosts(), this.dbService.getPort(), e.getMessage())));
        }
    }

    public List<CloudId> searchByIdWithPagination(String start, int end, String providerId) {
        ArrayList<CloudId> result2 = new ArrayList<CloudId>();
        Bucket bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, providerId);
        while (bucket != null) {
            ResultSet rs = this.dbService.getSession().execute(this.searchByProviderPaginatedStatement.bind(providerId, java.util.UUID.fromString(bucket.getBucketId()), start, end));
            result2.addAll(this.createCloudIdsFromRs(rs));
            if (result2.size() >= end) break;
            bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, providerId, bucket);
        }
        return result2;
    }

    public List<CloudId> insert(String ... args) throws DatabaseConnectionException {
        try {
            Bucket bucket = this.bucketsHandler.getCurrentBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, args[0]);
            if (bucket == null || bucket.getRowsCount() == 950000L) {
                bucket = new Bucket(args[0], new UUID().toString(), 0L);
            }
            this.bucketsHandler.increaseBucketCount(PROVIDER_RECORD_ID_BUCKETS_TABLE, bucket);
            this.dbService.getSession().execute(this.insertStatement.bind(args[0], java.util.UUID.fromString(bucket.getBucketId()), args[1], args[2]));
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.dbService.getHosts(), this.dbService.getPort(), e.getMessage())));
        }
        ArrayList<CloudId> cIds = new ArrayList<CloudId>();
        CloudId cId = new CloudId();
        LocalId lId = new LocalId();
        lId.setProviderId(args[0]);
        lId.setRecordId(args[1]);
        cId.setLocalId(lId);
        cId.setId(args[2]);
        cIds.add(cId);
        return cIds;
    }

    public void delete(String providerId, String recordId) throws DatabaseConnectionException {
        try {
            ResultSet rs = null;
            Bucket bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, providerId);
            while (bucket != null) {
                rs = this.dbService.getSession().execute(this.searchByRecordIdStatement.bind(providerId, java.util.UUID.fromString(bucket.getBucketId()), recordId));
                if (rs.getAvailableWithoutFetching() == 1) {
                    this.dbService.getSession().execute(this.deleteStatement.bind(providerId, java.util.UUID.fromString(bucket.getBucketId()), recordId));
                    if (bucket.getRowsCount() == 1L) {
                        this.bucketsHandler.removeBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, bucket);
                    } else {
                        this.bucketsHandler.decreaseBucketCount(PROVIDER_RECORD_ID_BUCKETS_TABLE, bucket);
                    }
                    break;
                }
                bucket = this.bucketsHandler.getNextBucket(PROVIDER_RECORD_ID_BUCKETS_TABLE, providerId, bucket);
            }
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.dbService.getHosts(), this.dbService.getPort(), e.getMessage())));
        }
    }

    private List<CloudId> createCloudIdsFromRs(ResultSet rs) {
        ArrayList<CloudId> cloudIds = new ArrayList<CloudId>();
        if (rs != null) {
            for (Row row : rs.all()) {
                LocalId lId = new LocalId();
                lId.setProviderId(row.getString("provider_Id"));
                lId.setRecordId(row.getString("record_Id"));
                CloudId cloudId = new CloudId();
                cloudId.setId(row.getString("cloud_id"));
                cloudId.setLocalId(lId);
                cloudIds.add(cloudId);
            }
        }
        return cloudIds;
    }
}

