/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.commons.logging;

import eu.europeana.cloud.service.commons.logging.LoggingConfigurator;
import eu.europeana.cloud.service.coordination.registration.ZookeeperServiceAdvertiser;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperLoggingConfigurator
extends LoggingConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperLoggingConfigurator.class);
    private ZookeeperServiceAdvertiser serviceAdvertiser;
    private String kafkaBrokerList;
    private String kafkaTopicName;

    public ZookeeperLoggingConfigurator(ZookeeperServiceAdvertiser serviceAdvertiser, String kafkaBrokerList, String kafkaTopicName) {
        this.serviceAdvertiser = serviceAdvertiser;
        this.kafkaBrokerList = kafkaBrokerList;
        this.kafkaTopicName = kafkaTopicName;
    }

    @Override
    @PostConstruct
    public void configure() {
        LOGGER.info("Start configuring logging system using Zookeeper");
        String serviceName = this.serviceAdvertiser.getServiceProperties().getServiceName().toLowerCase();
        String hostname = this.readHostname(this.serviceAdvertiser);
        org.apache.log4j.Logger applicationRootLogger = org.apache.log4j.Logger.getRootLogger();
        this.loggerUpdater.update(applicationRootLogger, "instanceName", hostname);
        this.loggerUpdater.addKafkaAppender(applicationRootLogger, this.kafkaBrokerList, this.kafkaTopicName, serviceName, hostname);
        LOGGER.info("Logging system configuration finished");
    }
}

