/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import eu.europeana.cloud.common.model.dps.SubTaskInfo;
import eu.europeana.cloud.common.model.dps.TaskState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TaskInfo {
    private static final int DEFAULT_PROGRESS_PERCENTAGE = -1;
    private long id;
    private String topologyName;
    private int expectedSize;
    private int processedElementCount;
    private TaskState state;
    private String info;
    private Date finishDate;
    private Date startDate;
    private Date sentDate;
    private int processedPercentage;
    private int errors;
    private List<SubTaskInfo> subtasks = new ArrayList<SubTaskInfo>();

    public void setId(long id) {
        this.id = id;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public TaskInfo() {
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public void setSubtasks(List<SubTaskInfo> subtasks) {
        this.subtasks = subtasks;
    }

    public int getProcessedElementCount() {
        return this.processedElementCount;
    }

    public void setProcessedElementCount(int processedElementCount) {
        this.processedElementCount = processedElementCount;
    }

    public int getProcessedPercentage() {
        return this.processedPercentage;
    }

    public void setProcessedPercentage(int processedPercentage) {
        this.processedPercentage = processedPercentage;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    private void calculateProgress() {
        this.processedPercentage = this.expectedSize < 0 ? -1 : (this.expectedSize > 0 ? 100 * this.processedElementCount / this.expectedSize : 0);
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info, Date sentDate, Date startDate, Date finishDate) {
        this(id, topologyName, state, info, 0, 0, 0, sentDate, startDate, finishDate);
    }

    public TaskInfo(long id, String topologyName, TaskState state, String info, int containsElements, int processedElementCount, int errors, Date sentDate, Date startDate, Date finishDate) {
        this.id = id;
        this.topologyName = topologyName;
        this.state = state;
        this.info = info;
        this.expectedSize = containsElements;
        this.processedElementCount = processedElementCount;
        this.sentDate = sentDate;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.errors = errors;
        this.calculateProgress();
    }

    public long getId() {
        return this.id;
    }

    public String getTopologyName() {
        return this.topologyName;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public void setExpectedSize(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public List<SubTaskInfo> getSubtasks() {
        return Collections.unmodifiableList(this.subtasks);
    }

    public void addSubtask(SubTaskInfo subtask) {
        this.subtasks.add(subtask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo taskInfo = (TaskInfo)o;
        if (this.expectedSize != taskInfo.expectedSize) {
            return false;
        }
        if (this.errors != taskInfo.errors) {
            return false;
        }
        if (this.processedPercentage != taskInfo.processedPercentage) {
            return false;
        }
        if (this.id != taskInfo.id) {
            return false;
        }
        if (this.subtasks != null ? !this.subtasks.equals(taskInfo.subtasks) : taskInfo.subtasks != null) {
            return false;
        }
        if (this.topologyName != null ? !this.topologyName.equals(taskInfo.topologyName) : taskInfo.topologyName != null) {
            return false;
        }
        if (this.state != taskInfo.state) {
            return false;
        }
        if (this.startDate == null && taskInfo.startDate != null) {
            return false;
        }
        if (this.startDate != null && taskInfo.startDate != null && this.startDate.getTime() != taskInfo.startDate.getTime()) {
            return false;
        }
        if (this.sentDate == null && taskInfo.sentDate != null) {
            return false;
        }
        if (this.sentDate != null && taskInfo.sentDate != null && this.sentDate.getTime() != taskInfo.sentDate.getTime()) {
            return false;
        }
        if (this.finishDate == null && taskInfo.finishDate != null) {
            return false;
        }
        return this.finishDate == null || taskInfo.finishDate == null || this.finishDate.getTime() == taskInfo.finishDate.getTime();
    }

    public int hashCode() {
        int result2 = (int)(this.id ^ this.id >>> 32);
        result2 = 31 * result2 + (this.topologyName != null ? this.topologyName.hashCode() : 0);
        result2 = 31 * result2 + this.expectedSize;
        result2 = 31 * result2 + this.errors;
        result2 = 31 * result2 + this.processedPercentage;
        result2 = 31 * result2 + (this.subtasks != null ? this.subtasks.hashCode() : 0);
        result2 = 31 * result2 + (this.state != null ? this.state.hashCode() : 0);
        result2 = 31 * result2 + (this.startDate != null ? this.startDate.hashCode() : 0);
        result2 = 31 * result2 + (this.sentDate != null ? this.sentDate.hashCode() : 0);
        return result2;
    }
}

