/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.module.impl.ModuleClassLoader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;

final class ClassLoaderFacade
extends URLClassLoader {
    private static final URL[] EMPTY_URLS = new URL[0];
    private HashSet<String> publicPkgs = null;
    private ArrayList<String> publicSet = null;
    private ModuleClassLoader privateLoader;
    private int classesLoaded = 0;

    public ClassLoaderFacade(ModuleClassLoader privateLoader) {
        super(EMPTY_URLS, privateLoader.getParent());
        this.privateLoader = privateLoader;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LogHelper.getDefaultLogger().fine("Facade ClassLoader killed " + this.privateLoader.getOwner().getModuleDefinition().getName());
        this.privateLoader.stop();
    }

    public void setPublicPkgs(String[] publicPkgs) {
        if (publicPkgs == null || publicPkgs.length == 0) {
            return;
        }
        for (String publicPkg : publicPkgs) {
            if (publicPkg.endsWith(".")) {
                if (this.publicSet == null) {
                    this.publicSet = new ArrayList();
                }
                this.publicSet.add(publicPkg);
                continue;
            }
            if (this.publicPkgs == null) {
                this.publicPkgs = new HashSet();
            }
            this.publicPkgs.add(publicPkg);
        }
    }

    public String[] getPublicPkgs() {
        return this.publicPkgs.toArray(new String[this.publicPkgs.size()]);
    }

    boolean matchExportedPackage(String name) {
        if (this.publicPkgs == null && this.publicSet == null) {
            return true;
        }
        if (this.publicSet != null) {
            for (String aPublicSet : this.publicSet) {
                if (!name.startsWith(aPublicSet)) continue;
                return true;
            }
        }
        if (this.publicPkgs == null) {
            return false;
        }
        int index2 = name.lastIndexOf(46);
        if (index2 == -1) {
            return false;
        }
        String packageName = name.substring(0, index2);
        return this.publicPkgs.contains(packageName);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.matchExportedPackage(name)) {
            return this.privateLoader.loadClass(name);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        return this.privateLoader.findResources(name);
    }

    @Override
    public URL findResource(String name) {
        return this.privateLoader.findResource(name);
    }

    Class getClass(String name) throws ClassNotFoundException {
        if (this.matchExportedPackage(name)) {
            Class c = this.privateLoader.findClassDirect(name);
            ++this.classesLoaded;
            return c;
        }
        return null;
    }

    URL findResourceDirect(String name) {
        return this.privateLoader.findResourceDirect(name);
    }

    public void dumpState(PrintStream writer) {
        this.privateLoader.dumpState(writer);
        writer.println("Nb of classes loaded " + this.classesLoaded);
    }

    public String toString() {
        return super.toString() + " Facade for " + this.privateLoader.toString();
    }
}

