/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableData;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.nio.ByteBuffer;
import java.util.List;

class ArrayBackedRow
extends AbstractGettableData
implements Row {
    private final ColumnDefinitions metadata;
    private final Token.Factory tokenFactory;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, List<ByteBuffer> data2) {
        super(protocolVersion);
        this.metadata = metadata;
        this.tokenFactory = tokenFactory;
        this.data = data2;
    }

    static Row fromData(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, List<ByteBuffer> data2) {
        if (data2 == null) {
            return null;
        }
        return new ArrayBackedRow(metadata, tokenFactory, protocolVersion, data2);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    protected DataType getType(int i) {
        return this.metadata.getType(i);
    }

    @Override
    protected String getName(int i) {
        return this.metadata.getName(i);
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.data.get(i);
    }

    @Override
    protected int getIndexOf(String name) {
        return this.metadata.getFirstIdx(name);
    }

    @Override
    public Token getToken(int i) {
        if (this.tokenFactory == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        this.metadata.checkType(i, this.tokenFactory.getTokenType().getName());
        ByteBuffer value2 = this.data.get(i);
        if (value2 == null || value2.remaining() == 0) {
            return null;
        }
        return this.tokenFactory.deserialize(value2, this.protocolVersion);
    }

    @Override
    public Token getToken(String name) {
        return this.getToken(this.metadata.getFirstIdx(name));
    }

    @Override
    public Token getPartitionKeyToken() {
        int i = 0;
        for (ColumnDefinitions.Definition column : this.metadata) {
            if (column.getName().matches("token(.*)")) {
                return this.getToken(i);
            }
            ++i;
        }
        throw new IllegalStateException("Found no column named 'token(...)'. If the column is aliased, use getToken(String).");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(this.metadata.getType(i).codec(this.protocolVersion).deserialize(bb).toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

