/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractGettableByIndexData;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

abstract class AbstractAddressableByIndexData<T extends SettableByIndexData<T>>
extends AbstractGettableByIndexData
implements SettableByIndexData<T> {
    final ByteBuffer[] values;

    protected AbstractAddressableByIndexData(ProtocolVersion protocolVersion, int size2) {
        super(protocolVersion);
        this.values = new ByteBuffer[size2];
    }

    protected T setValue(int i, ByteBuffer value2) {
        this.values[i] = value2;
        return (T)this;
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.values[i];
    }

    @Override
    public T setBool(int i, boolean v) {
        this.checkType(i, DataType.Name.BOOLEAN);
        return this.setValue(i, TypeCodec.booleanCodec.serializeNoBoxing(v));
    }

    @Override
    public T setInt(int i, int v) {
        this.checkType(i, DataType.Name.INT);
        return this.setValue(i, TypeCodec.intCodec.serializeNoBoxing(v));
    }

    @Override
    public T setLong(int i, long v) {
        this.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        return this.setValue(i, TypeCodec.longCodec.serializeNoBoxing(v));
    }

    @Override
    public T setDate(int i, Date v) {
        this.checkType(i, DataType.Name.TIMESTAMP);
        return this.setValue(i, v == null ? null : TypeCodec.dateCodec.serialize(v));
    }

    @Override
    public T setFloat(int i, float v) {
        this.checkType(i, DataType.Name.FLOAT);
        return this.setValue(i, TypeCodec.floatCodec.serializeNoBoxing(v));
    }

    @Override
    public T setDouble(int i, double v) {
        this.checkType(i, DataType.Name.DOUBLE);
        return this.setValue(i, TypeCodec.doubleCodec.serializeNoBoxing(v));
    }

    @Override
    public T setString(int i, String v) {
        DataType.Name type = this.checkType(i, DataType.Name.VARCHAR, DataType.Name.TEXT, DataType.Name.ASCII);
        switch (type) {
            case ASCII: {
                return this.setValue(i, v == null ? null : TypeCodec.asciiStringCodec.serialize(v));
            }
            case TEXT: 
            case VARCHAR: {
                return this.setValue(i, v == null ? null : TypeCodec.utf8StringCodec.serialize(v));
            }
        }
        throw new AssertionError();
    }

    @Override
    public T setBytes(int i, ByteBuffer v) {
        this.checkType(i, DataType.Name.BLOB);
        return this.setBytesUnsafe(i, v);
    }

    @Override
    public T setBytesUnsafe(int i, ByteBuffer v) {
        return this.setValue(i, v == null ? null : v.duplicate());
    }

    @Override
    public T setVarint(int i, BigInteger v) {
        this.checkType(i, DataType.Name.VARINT);
        return this.setValue(i, v == null ? null : TypeCodec.bigIntegerCodec.serialize(v));
    }

    @Override
    public T setDecimal(int i, BigDecimal v) {
        this.checkType(i, DataType.Name.DECIMAL);
        return this.setValue(i, v == null ? null : TypeCodec.decimalCodec.serialize(v));
    }

    @Override
    public T setUUID(int i, UUID v) {
        DataType.Name type = this.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        if (v == null) {
            return this.setValue(i, null);
        }
        if (type == DataType.Name.TIMEUUID && v.version() != 1) {
            throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", v));
        }
        return type == DataType.Name.UUID ? this.setValue(i, TypeCodec.uuidCodec.serialize(v)) : this.setValue(i, TypeCodec.timeUuidCodec.serialize(v));
    }

    @Override
    public T setInet(int i, InetAddress v) {
        this.checkType(i, DataType.Name.INET);
        return this.setValue(i, v == null ? null : TypeCodec.inetCodec.serialize(v));
    }

    @Override
    public <E> T setList(int i, List<E> v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.LIST) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a list", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Class<?> providedClass = v.get(0).getClass();
            Class<?> expectedClass = type.getTypeArguments().get(0).asJavaClass();
            if (!expectedClass.isAssignableFrom(providedClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting list of %s but provided list of %s", this.getName(i), type, expectedClass, providedClass));
            }
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public <K, V> T setMap(int i, Map<K, V> v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.MAP) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a map", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty()) {
            Map.Entry<K, V> entry2 = v.entrySet().iterator().next();
            Class<?> providedKeysClass = entry2.getKey().getClass();
            Class<?> providedValuesClass = entry2.getValue().getClass();
            Class<?> expectedKeysClass = type.getTypeArguments().get((int)0).getName().javaType;
            Class<?> expectedValuesClass = type.getTypeArguments().get((int)1).getName().javaType;
            if (!expectedKeysClass.isAssignableFrom(providedKeysClass) || !expectedValuesClass.isAssignableFrom(providedValuesClass)) {
                throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting map of %s->%s but provided map of %s->%s", this.getName(i), type, expectedKeysClass, expectedValuesClass, providedKeysClass, providedValuesClass));
            }
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public <E> T setSet(int i, Set<E> v) {
        Class<?> providedClass;
        Class<?> expectedClass;
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.SET) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a set", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        if (!v.isEmpty() && !(expectedClass = type.getTypeArguments().get((int)0).getName().javaType).isAssignableFrom(providedClass = v.iterator().next().getClass())) {
            throw new InvalidTypeException(String.format("Invalid value for column %s of CQL type %s, expecting set of %s but provided set of %s", this.getName(i), type, expectedClass, providedClass));
        }
        return this.setValue(i, type.codec(this.protocolVersion).serialize(v));
    }

    @Override
    public T setUDTValue(int i, UDTValue v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.UDT) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a UDT", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        return this.setValue(i, type.codec(ProtocolVersion.V3).serialize(v));
    }

    @Override
    public T setTupleValue(int i, TupleValue v) {
        DataType type = this.getType(i);
        if (type.getName() != DataType.Name.TUPLE) {
            throw new InvalidTypeException(String.format("Column %s is of type %s, cannot set to a tuple", this.getName(i), type));
        }
        if (v == null) {
            return this.setValue(i, null);
        }
        return this.setValue(i, type.codec(ProtocolVersion.V3).serialize(v));
    }

    @Override
    public T setToNull(int i) {
        return this.setValue(i, null);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractAddressableByIndexData)) {
            return false;
        }
        AbstractAddressableByIndexData that = (AbstractAddressableByIndexData)o;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            DataType thatType;
            DataType thisType = this.getType(i);
            if (!thisType.equals(thatType = that.getType(i))) {
                return false;
            }
            if (this.values[i] == null != (that.values[i] == null)) {
                return false;
            }
            if (this.values[i] == null || thisType.deserialize(this.values[i], this.protocolVersion).equals(thatType.deserialize(that.values[i], this.protocolVersion))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash2 = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hash2 += this.values[i] == null ? 1 : this.getType(i).deserialize(this.values[i], this.protocolVersion).hashCode();
        }
        return hash2;
    }
}

