/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.MessageConveyorException;
import ch.qos.cal10n.util.LexicalUtil;
import ch.qos.cal10n.util.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenStream {
    BufferedReader lineReader;
    State state = State.START;

    TokenStream(Reader reader) {
        this.lineReader = new BufferedReader(reader);
    }

    List<Token> tokenize() {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        while (true) {
            String currentLine;
            try {
                currentLine = this.lineReader.readLine();
            }
            catch (IOException e) {
                throw new MessageConveyorException("Failed to read input stream", e);
            }
            if (currentLine == null) break;
            if (this.state != State.TRAILING_BACKSLASH) {
                this.state = State.START;
            }
            this.tokenizeLine(tokenList, currentLine);
            tokenList.add(Token.EOL);
        }
        return tokenList;
    }

    private void tokenizeLine(List<Token> tokenList, String line) {
        int len = line.length();
        StringBuilder buf = new StringBuilder();
        block7: for (int pointer = 0; pointer < len; ++pointer) {
            char c = line.charAt(pointer);
            switch (this.state) {
                case START: {
                    if (this.isWhiteSpace(c)) continue block7;
                    if (c == '#') {
                        this.state = State.COMMENT;
                        return;
                    }
                    if (this.isNonWhiteSpaceSeparator(c)) {
                        this.state = State.SEPARATOR;
                        buf.append(c);
                        continue block7;
                    }
                    this.state = State.KEY;
                    buf.append(c);
                    continue block7;
                }
                case KEY: {
                    String lexicalValue;
                    if (this.isWhiteSpace(c) || this.isNonWhiteSpaceSeparator(c)) {
                        lexicalValue = LexicalUtil.convertSpecialCharacters(buf).toString();
                        tokenList.add(new Token(Token.TokenType.KEY, lexicalValue));
                        buf.setLength(0);
                        buf.append(c);
                        this.state = State.SEPARATOR;
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case SEPARATOR: {
                    if (this.isWhiteSpace(c) || this.isNonWhiteSpaceSeparator(c)) {
                        buf.append(c);
                        continue block7;
                    }
                    tokenList.add(new Token(Token.TokenType.SEPARATOR, buf.toString()));
                    buf.setLength(0);
                    buf.append(c);
                    this.state = State.VAL;
                    continue block7;
                }
                case VAL: {
                    String lexicalValue;
                    if (c == '\\') {
                        if (this.isTrailingBackSlash(line, pointer + 1)) {
                            lexicalValue = LexicalUtil.convertSpecialCharacters(buf).toString();
                            tokenList.add(new Token(Token.TokenType.VALUE, lexicalValue));
                            buf.setLength(0);
                            this.state = State.TRAILING_BACKSLASH;
                            tokenList.add(Token.TRAILING_BACKSLASH);
                            return;
                        }
                        buf.append(c);
                        continue block7;
                    }
                    buf.append(c);
                    continue block7;
                }
                case TRAILING_BACKSLASH: {
                    if (this.isWhiteSpace(c)) continue block7;
                    buf.append(c);
                    this.state = State.VAL;
                }
            }
        }
        if (this.state == State.VAL) {
            String lexicalValue = LexicalUtil.convertSpecialCharacters(buf).toString();
            tokenList.add(new Token(Token.TokenType.VALUE, lexicalValue));
            buf.setLength(0);
        }
    }

    boolean isTrailingBackSlash(String line, int next2) {
        int len = line.length();
        for (int i = next2; i < len; ++i) {
            char c = line.charAt(i);
            if (this.isWhiteSpace(c)) continue;
            return false;
        }
        return true;
    }

    boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    boolean isNonWhiteSpaceSeparator(char c) {
        switch (c) {
            case ':': 
            case '=': {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        START,
        COMMENT,
        KEY,
        SEPARATOR,
        VAL,
        TRAILING_BACKSLASH;

    }
}

