/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.AnnotationTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ExtensibleTypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.FieldModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.MethodModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.SignatureVisitorImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeBuilder;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;
import org.glassfish.hk2.external.org.objectweb.asm.AnnotationVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.Attribute;
import org.glassfish.hk2.external.org.objectweb.asm.ClassVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.FieldVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.MethodVisitor;
import org.glassfish.hk2.external.org.objectweb.asm.signature.SignatureReader;

public class ModelClassVisitor
extends ClassVisitor {
    private static Logger logger = Logger.getLogger(ModelClassVisitor.class.getName());
    private final ParsingContext ctx;
    private final TypeBuilder typeBuilder;
    private final URI definingURI;
    private final String entryName;
    TypeImpl type;
    boolean deepVisit = false;
    private final ClassVisitingContext classContext;
    private final MemberVisitingContext visitingContext;
    private final ModelFieldVisitor fieldVisitor;
    private final ModelMethodVisitor methodVisitor;
    private final ModelAnnotationVisitor annotationVisitor;
    private final ModelDefaultAnnotationVisitor defaultAnnotationVisitor;
    private static int discarded = 0;
    private boolean isApplicationClass;

    public ModelClassVisitor(ParsingContext ctx, URI definingURI, String entryName, boolean isApplicationClass) {
        super(327680);
        this.ctx = ctx;
        this.definingURI = definingURI;
        this.entryName = entryName;
        this.typeBuilder = ctx.getTypeBuilder(definingURI);
        this.classContext = new ClassVisitingContext();
        this.visitingContext = new MemberVisitingContext(ctx.getConfig().modelUnAnnotatedMembers());
        this.fieldVisitor = new ModelFieldVisitor(this.visitingContext);
        this.methodVisitor = new ModelMethodVisitor(this.visitingContext);
        this.annotationVisitor = new ModelAnnotationVisitor();
        this.defaultAnnotationVisitor = new ModelDefaultAnnotationVisitor(this.methodVisitor.getContext());
        this.isApplicationClass = isApplicationClass;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String parentName = superName != null ? org.glassfish.hk2.external.org.objectweb.asm.Type.getObjectType(superName).getClassName() : null;
        TypeProxy<? extends Type> parent = null;
        Class<? extends Type> typeType = this.typeBuilder.getType(access);
        if (!typeType.equals(AnnotationType.class)) {
            TypeProxy<? extends Type> typeProxy = parent = parentName != null ? this.typeBuilder.getHolder(parentName, typeType) : null;
        }
        if (parent != null && !parentName.equals(Object.class.getName())) {
            TypeImpl parentType = this.typeBuilder.getType(access, parentName, null);
            parent.set(parentType);
        }
        String className = org.glassfish.hk2.external.org.objectweb.asm.Type.getObjectType(name).getClassName();
        URI classDefURI = null;
        try {
            int index = this.entryName.length() - name.length() - 6;
            if (null == this.definingURI || index == 0) {
                classDefURI = this.definingURI;
            } else {
                String newPath = index > 0 ? this.definingURI.getPath() + this.entryName.substring(0, index) : this.definingURI.getPath();
                classDefURI = new URI(this.definingURI.getScheme(), newPath, this.definingURI.getFragment());
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "visiting {0} with classDefURI={1}", new Object[]{this.entryName, classDefURI});
        }
        this.type = this.ctx.getTypeBuilder(classDefURI).getType(access, className, parent);
        this.type.setApplicationClass(this.isApplicationClass);
        this.type.getProxy().visited();
        this.type.addDefiningURI(classDefURI);
        this.deepVisit = this.ctx.getConfig().getAnnotationsOfInterest().isEmpty();
        this.classContext.type = this.type;
        this.classContext.interfaces = interfaces;
        this.classContext.parent = parent;
        if (parent != null) {
            parent.addSubTypeRef(this.type);
        }
        try {
            ExtensibleTypeImpl classModel = (ExtensibleTypeImpl)this.type;
            if (signature != null) {
                SignatureReader reader = new SignatureReader(signature);
                SignatureVisitorImpl signatureVisitor = new SignatureVisitorImpl(this.typeBuilder);
                reader.accept(signatureVisitor);
                if (!signatureVisitor.getImplementedInterfaces().isEmpty()) {
                    for (ParameterizedInterfaceModelImpl pim : signatureVisitor.getImplementedInterfaces()) {
                        if (pim.getRawInterfaceProxy() == null) continue;
                        classModel.isImplementing(pim);
                        if (!(classModel instanceof ClassModel)) continue;
                        pim.getRawInterfaceProxy().addImplementation((ClassModel)((Object)classModel));
                    }
                }
            } else if (!typeType.equals(AnnotationType.class)) {
                for (String intf : interfaces) {
                    String interfaceName = org.glassfish.hk2.external.org.objectweb.asm.Type.getObjectType(intf).getClassName();
                    TypeImpl interfaceModel = this.typeBuilder.getType(512, interfaceName, null);
                    TypeProxy<InterfaceModel> typeProxy = this.typeBuilder.getHolder(interfaceName, InterfaceModel.class);
                    if (typeProxy.get() == null) {
                        typeProxy.set((InterfaceModel)((Object)interfaceModel));
                    }
                    classModel.isImplementing(typeProxy);
                    if (!(classModel instanceof ClassModel)) continue;
                    typeProxy.addImplementation((ClassModel)((Object)classModel));
                }
            }
        }
        catch (ClassCastException e) {
        }
        catch (Exception ne) {
            ne.printStackTrace();
        }
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        desc = this.unwrap(desc);
        AnnotationTypeImpl at = (AnnotationTypeImpl)this.typeBuilder.getType(8192, desc, null);
        AnnotationModelImpl am = new AnnotationModelImpl(this.type, at);
        at.getAnnotatedElements().add(this.type);
        this.type.addAnnotation(am);
        if (this.ctx.getConfig().getAnnotationsOfInterest().contains(desc)) {
            logger.log(Level.FINER, "Inspecting fields of {0}", this.type.getName());
            this.deepVisit = true;
        }
        this.annotationVisitor.getContext().annotation = am;
        return this.annotationVisitor;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldModelImpl field;
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleTypeImpl)) {
            logger.severe("Field visitor invoked for field " + name + "in type " + this.type.getName() + " which is not a ClassModel type instance but a " + this.type.getClass().getName());
            return null;
        }
        ExtensibleTypeImpl cm = (ExtensibleTypeImpl)this.type;
        org.glassfish.hk2.external.org.objectweb.asm.Type asmType = org.glassfish.hk2.external.org.objectweb.asm.Type.getType(desc);
        TypeProxy fieldType = this.typeBuilder.getHolder(asmType.getClassName());
        if (fieldType == null) {
            return null;
        }
        this.fieldVisitor.getContext().field = field = this.typeBuilder.getFieldModel(name, fieldType, cm);
        this.fieldVisitor.getContext().typeDesc = desc;
        this.fieldVisitor.getContext().access = access;
        this.fieldVisitor.getContext().classModel = cm;
        return this.fieldVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!this.deepVisit) {
            return null;
        }
        if (!(this.type instanceof ExtensibleType)) {
            logger.severe("Method visitor invoked for method " + name + "in type " + this.type.getName() + " which is not an ExtensibleType type instance but a " + this.type.getClass().getName());
            return null;
        }
        ExtensibleType cm = (ExtensibleType)((Object)this.type);
        this.methodVisitor.getContext().method = new MethodModelImpl(name, cm, signature == null ? desc : signature);
        return this.methodVisitor;
    }

    @Override
    public void visitEnd() {
        this.type = null;
    }

    private String unwrap(String desc) {
        return org.glassfish.hk2.external.org.objectweb.asm.Type.getType(desc).getClassName();
    }

    private class ModelAnnotationVisitor
    extends AnnotationVisitor {
        private final AnnotationVisitingContext context;

        private ModelAnnotationVisitor() {
            super(327680);
            this.context = new AnnotationVisitingContext();
        }

        AnnotationVisitingContext getContext() {
            return this.context;
        }

        @Override
        public void visit(String name, Object value) {
            if (this.context.annotation == null) {
                return;
            }
            this.context.annotation.addValue(name, value);
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            if (this.context.annotation == null) {
                return null;
            }
            this.context.annotation.addValue(name, null);
            return null;
        }

        @Override
        public void visitEnd() {
        }
    }

    private class ModelFieldVisitor
    extends FieldVisitor {
        private final FieldVisitingContext context;

        private ModelFieldVisitor(MemberVisitingContext context) {
            super(327680);
            this.context = new FieldVisitingContext(context.modelUnAnnotatedMembers);
        }

        FieldVisitingContext getContext() {
            return this.context;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String s, boolean b) {
            FieldModelImpl field = this.context.field;
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(s), null);
            AnnotationModelImpl annotationModel = new AnnotationModelImpl(field, annotationType);
            annotationType.getAnnotatedElements().add(field);
            field.addAnnotation(annotationModel);
            ((ModelClassVisitor)ModelClassVisitor.this).annotationVisitor.getContext().annotation = annotationModel;
            return ModelClassVisitor.this.annotationVisitor;
        }

        @Override
        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.field.getAnnotations().isEmpty()) {
                this.context.field.type.addFieldRef(this.context.field);
                if ((8 & this.context.access) == 8) {
                    this.context.classModel.addStaticField(this.context.field);
                } else {
                    this.context.classModel.addField(this.context.field);
                }
            }
            this.context.field = null;
        }
    }

    private class ModelDefaultAnnotationVisitor
    extends AnnotationVisitor {
        private final MethodVisitingContext context;

        public ModelDefaultAnnotationVisitor(MethodVisitingContext visitingContext) {
            super(327680);
            this.context = visitingContext;
        }

        @Override
        public void visit(String desc, Object value) {
            AnnotationTypeImpl am = (AnnotationTypeImpl)this.context.method.owner;
            am.addDefaultValue(this.context.method.getName(), value);
        }
    }

    private class ModelMethodVisitor
    extends MethodVisitor {
        private final MethodVisitingContext context;

        private ModelMethodVisitor(MemberVisitingContext context) {
            super(327680);
            this.context = new MethodVisitingContext(context.modelUnAnnotatedMembers);
        }

        MethodVisitingContext getContext() {
            return this.context;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.context.method == null) {
                return null;
            }
            AnnotationTypeImpl annotationType = (AnnotationTypeImpl)ModelClassVisitor.this.typeBuilder.getType(8192, ModelClassVisitor.this.unwrap(desc), null);
            AnnotationModelImpl am = new AnnotationModelImpl(this.context.method, annotationType);
            annotationType.getAnnotatedElements().add(this.context.method);
            this.context.method.addAnnotation(am);
            ((ModelClassVisitor)ModelClassVisitor.this).annotationVisitor.getContext().annotation = am;
            return ModelClassVisitor.this.annotationVisitor;
        }

        @Override
        public void visitEnd() {
            if (this.context.modelUnAnnotatedMembers || !this.context.method.getAnnotations().isEmpty()) {
                ModelClassVisitor.this.type.addMethod(this.context.method);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return ModelClassVisitor.this.defaultAnnotationVisitor;
        }
    }

    private static class AnnotationVisitingContext {
        AnnotationModelImpl annotation;

        private AnnotationVisitingContext() {
        }
    }

    private static class MethodVisitingContext
    extends MemberVisitingContext {
        MethodModelImpl method;

        private MethodVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class FieldVisitingContext
    extends MemberVisitingContext {
        FieldModelImpl field;
        String typeDesc;
        ExtensibleTypeImpl classModel;
        int access;

        private FieldVisitingContext(boolean modelUnAnnotatedMembers) {
            super(modelUnAnnotatedMembers);
        }
    }

    private static class MemberVisitingContext {
        final boolean modelUnAnnotatedMembers;

        private MemberVisitingContext(boolean modelUnAnnotatedMembers) {
            this.modelUnAnnotatedMembers = modelUnAnnotatedMembers;
        }
    }

    private static class ClassVisitingContext {
        TypeImpl type;
        TypeProxy parent;
        String[] interfaces;

        private ClassVisitingContext() {
        }
    }
}

