/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.persistent.dao;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import eu.europeana.cloud.cassandra.CassandraConnectionProvider;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.IdentifierErrorInfo;
import eu.europeana.cloud.common.model.LocalId;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.status.IdentifierErrorTemplate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CassandraLocalIdDAO {
    private String hostList;
    private String port;
    private String keyspaceName;
    private CassandraConnectionProvider dbService;
    private PreparedStatement insertStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement updateStatement;
    private PreparedStatement searchByProviderStatement;
    private PreparedStatement searchByRecordIdStatement;
    private PreparedStatement searchByProviderAndRecordLessThanStatement;

    public CassandraLocalIdDAO(CassandraConnectionProvider dbService) {
        this.dbService = dbService;
        this.hostList = dbService.getHosts();
        this.port = dbService.getPort();
        this.keyspaceName = dbService.getKeyspaceName();
        this.prepareStatements();
    }

    private void prepareStatements() {
        this.insertStatement = this.dbService.getSession().prepare("INSERT INTO Provider_Record_Id(provider_id,record_id,cloud_id,deleted) VALUES(?,?,?,false)");
        this.insertStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.deleteStatement = this.dbService.getSession().prepare("UPDATE Provider_Record_Id SET deleted=true WHERE provider_id=? AND record_Id=?");
        this.deleteStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.updateStatement = this.dbService.getSession().prepare("UPDATE Provider_Record_Id SET cloud_id=? WHERE provider_id=? AND record_Id=?");
        this.updateStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByProviderStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id=? AND deleted = ?");
        this.searchByProviderStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByRecordIdStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id=? AND record_id=? AND deleted=?");
        this.searchByRecordIdStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
        this.searchByProviderAndRecordLessThanStatement = this.dbService.getSession().prepare("SELECT * FROM Provider_Record_Id WHERE provider_id=? AND record_id>? AND deleted=? LIMIT ?");
        this.searchByProviderAndRecordLessThanStatement.setConsistencyLevel(this.dbService.getConsistencyLevel());
    }

    public List<CloudId> searchById(boolean deleted, String ... args) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        try {
            ResultSet rs = null;
            if (args.length == 1) {
                rs = this.dbService.getSession().execute(this.searchByProviderStatement.bind(args[0], deleted));
            } else if (args.length >= 2) {
                rs = this.dbService.getSession().execute(this.searchByRecordIdStatement.bind(args[0], args[1], deleted));
            }
            return this.createCloudIdsFromRs(rs);
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.hostList, this.port, e.getMessage())));
        }
    }

    public List<CloudId> searchActive(String ... args) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        return this.searchById(false, args);
    }

    public List<CloudId> searchActiveWithPagination(String startRecordId, int limit, String providerId) throws ProviderDoesNotExistException, RecordDatasetEmptyException, DatabaseConnectionException {
        List<CloudId> first = this.searchActive(providerId, startRecordId);
        if (first.size() > 0 && first.size() < limit) {
            ResultSet lessThanRS = this.dbService.getSession().execute(this.searchByProviderAndRecordLessThanStatement.bind(providerId, startRecordId, false, limit - 1));
            List<CloudId> result = this.createCloudIdsFromRs(lessThanRS);
            result.add(0, first.get(0));
            return result;
        }
        return first;
    }

    public List<CloudId> insert(String ... args) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        try {
            this.dbService.getSession().execute(this.insertStatement.bind(args[0], args[1], args[2]));
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.hostList, this.port, e.getMessage())));
        }
        ArrayList<CloudId> cIds = new ArrayList<CloudId>();
        CloudId cId = new CloudId();
        LocalId lId = new LocalId();
        lId.setProviderId(args[0]);
        lId.setRecordId(args[1]);
        cId.setLocalId(lId);
        cId.setId(args[2]);
        cIds.add(cId);
        return cIds;
    }

    public void delete(String ... args) throws DatabaseConnectionException {
        try {
            this.dbService.getSession().execute(this.deleteStatement.bind(args[0], args[1]));
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.hostList, this.port, e.getMessage())));
        }
    }

    public void update(String ... args) throws DatabaseConnectionException {
        try {
            this.dbService.getSession().execute(this.updateStatement.bind(args[0], args[1], args[2]));
        }
        catch (NoHostAvailableException e) {
            throw new DatabaseConnectionException(new IdentifierErrorInfo(IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getHttpCode(), IdentifierErrorTemplate.DATABASE_CONNECTION_ERROR.getErrorInfo(this.hostList, this.port, e.getMessage())));
        }
    }

    public String getHostList() {
        return this.hostList;
    }

    public String getKeyspace() {
        return this.keyspaceName;
    }

    private List<CloudId> createCloudIdsFromRs(ResultSet rs) {
        LinkedList<CloudId> cloudIds = new LinkedList<CloudId>();
        if (rs != null) {
            for (Row row : rs.all()) {
                LocalId lId = new LocalId();
                lId.setProviderId(row.getString("provider_Id"));
                lId.setRecordId(row.getString("record_Id"));
                CloudId cloudId = new CloudId();
                cloudId.setId(row.getString("cloud_id"));
                cloudId.setLocalId(lId);
                cloudIds.add(cloudId);
            }
        }
        return cloudIds;
    }

    public String getPort() {
        return this.port;
    }
}

