/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.uis.ACLServiceWrapper;
import eu.europeana.cloud.service.uis.UniqueIdentifierService;
import eu.europeana.cloud.service.uis.exception.CloudIdAlreadyExistException;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.RecordExistsException;
import eu.europeana.cloud.service.uis.exception.RecordIdDoesNotExistException;
import eu.europeana.cloud.service.uis.rest.DataProviderResource;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;

@Component
@Path(value="/cloudIds")
@Scope(value="request")
public class UniqueIdentifierResource {
    @Autowired
    private UniqueIdentifierService uniqueIdentifierService;
    @Autowired
    private DataProviderResource dataProviderResource;
    private static final String CLOUDID = "cloudId";
    @Autowired
    private ACLServiceWrapper aclWrapper;
    private final String CLOUD_ID_CLASS_NAME = CloudId.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueIdentifierResource.class);

    @POST
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.model.CloudId")
    @PreAuthorize(value="isAuthenticated()")
    public Response createCloudId(@QueryParam(value="providerId") String providerId, @QueryParam(value="recordId") String localId) throws DatabaseConnectionException, RecordExistsException, ProviderDoesNotExistException, RecordDatasetEmptyException, CloudIdDoesNotExistException, CloudIdAlreadyExistException {
        CloudId cId = localId != null ? this.uniqueIdentifierService.createCloudId(new String[]{providerId, localId}) : this.uniqueIdentifierService.createCloudId(new String[]{providerId});
        Response response = Response.ok().entity((Object)cId).build();
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl cloudIdIdentity = new ObjectIdentityImpl(this.CLOUD_ID_CLASS_NAME, (Serializable)((Object)cId.getId()));
            MutableAcl cloudIdAcl = this.aclWrapper.getAcl(creatorName, (ObjectIdentity)cloudIdIdentity);
            this.aclWrapper.updateAcl(cloudIdAcl);
        }
        this.dataProviderResource.grantPermissionsToLocalId(cId, providerId);
        return response;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.model.CloudId")
    public Response getCloudId(@QueryParam(value="providerId") String providerId, @QueryParam(value="recordId") String recordId) throws DatabaseConnectionException, RecordDoesNotExistException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        return Response.ok((Object)this.uniqueIdentifierService.getCloudId(providerId, recordId)).build();
    }

    @GET
    @Path(value="{cloudId}")
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.CloudId>")
    public Response getLocalIds(@PathParam(value="cloudId") String cloudId) throws DatabaseConnectionException, CloudIdDoesNotExistException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        ResultSlice pList = new ResultSlice();
        pList.setResults(this.uniqueIdentifierService.getLocalIdsByCloudId(cloudId));
        return Response.ok((Object)pList).build();
    }

    @DELETE
    @Path(value="{cloudId}")
    @Produces(value={"application/xml", "application/json"})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Response deleteCloudId(@PathParam(value="cloudId") String cloudId) throws DatabaseConnectionException, CloudIdDoesNotExistException, ProviderDoesNotExistException, RecordIdDoesNotExistException {
        List removedCloudIds = this.uniqueIdentifierService.deleteCloudId(cloudId);
        for (CloudId cId : removedCloudIds) {
            this.dataProviderResource.deleteLocalIdAcl(cId.getLocalId().getRecordId(), cId.getLocalId().getProviderId());
        }
        ObjectIdentityImpl cloudIdentity = new ObjectIdentityImpl(this.CLOUD_ID_CLASS_NAME, (Serializable)((Object)cloudId));
        this.aclWrapper.deleteAcl((ObjectIdentity)cloudIdentity, false);
        return Response.ok((Object)"CloudId marked as deleted").build();
    }
}

