/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.uis.ACLServiceWrapper;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import eu.europeana.cloud.service.uis.rest.EnrichUriUtil;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;

@Path(value="/data-providers")
@Component
@Scope(value="request")
public class DataProvidersResource {
    @Autowired
    private DataProviderService providerService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    @Autowired
    private ACLServiceWrapper aclWrapper;
    private final String DATA_PROVIDER_CLASS_NAME = DataProvider.class.getName();

    @GET
    @Produces(value={"application/xml", "application/json"})
    public ResultSlice<DataProvider> getProviders(@QueryParam(value="from") String startFrom) {
        return this.providerService.getProviders(startFrom, this.numberOfElementsOnPage);
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Response createProvider(@Context UriInfo uriInfo, DataProviderProperties dataProviderProperties, @QueryParam(value="providerId") String providerId) throws ProviderAlreadyExistsException {
        DataProvider provider = this.providerService.createProvider(providerId, dataProviderProperties);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (DataProvider)provider);
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl providerIdentity = new ObjectIdentityImpl(this.DATA_PROVIDER_CLASS_NAME, (Serializable)((Object)providerId));
            MutableAcl providerAcl = this.aclWrapper.getAcl(creatorName, (ObjectIdentity)providerIdentity);
            this.aclWrapper.updateAcl(providerAcl);
        }
        return Response.created((URI)provider.getUri()).build();
    }
}

