/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;

public class ACLServiceWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACLServiceWrapper.class);
    private static final int DEFAULT_RETRIES = 3;
    private static final int SLEEP_TIME = 5000;
    private MutableAclService mutableAclService;

    public ACLServiceWrapper(MutableAclService mutableAclService) {
        this.mutableAclService = mutableAclService;
    }

    public MutableAcl getAcl(String creatorName, ObjectIdentity cloudIdIdentity) {
        MutableAcl acl = this.mutableAclService.createAcl(cloudIdIdentity);
        acl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
        acl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
        acl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
        acl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
        return acl;
    }

    public void updateAcl(MutableAcl providerAcl) {
        int retries = 3;
        while (true) {
            try {
                this.mutableAclService.updateAcl(providerAcl);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while updating ACLs for cloudId creation. Exception: {}", (Object)e.getMessage());
                throw e;
            }
            break;
        }
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) throws ChildrenExistException {
        this.mutableAclService.deleteAcl(objectIdentity, deleteChildren);
    }

    private void waitForSpecificTime() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            LOGGER.error(e1.getMessage());
        }
    }
}

