/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.service.uis.DataProviderService;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/active")
@Component
@Scope(value="request")
public class DataProviderActivationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataProviderActivationResource.class);
    @Autowired
    private DataProviderService providerService;

    @PUT
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Response activateDataProvider(@PathParam(value="DATAPROVIDER") String dataProviderId) throws ProviderDoesNotExistException {
        LOGGER.info("Activating data provider: {}", (Object)dataProviderId);
        DataProvider dataProvider = this.providerService.getProvider(dataProviderId);
        dataProvider.setActive(true);
        this.providerService.updateProvider(dataProvider);
        return Response.ok().build();
    }

    @DELETE
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Response deactivateDataProvider(@PathParam(value="DATAPROVIDER") String dataProviderId) throws ProviderDoesNotExistException {
        LOGGER.info("Deactivating data provider: {}", (Object)dataProviderId);
        DataProvider dataProvider = this.providerService.getProvider(dataProviderId);
        dataProvider.setActive(false);
        this.providerService.updateProvider(dataProvider);
        return Response.ok().build();
    }
}

