/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import eu.europeana.cloud.service.uis.rest.EnrichUriUtil;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/data-providers")
@Component
@Scope(value="request")
public class DataProvidersResource {
    @Autowired
    private DataProviderService providerService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    @Autowired
    private MutableAclService mutableAclService;
    private final String DATA_PROVIDER_CLASS_NAME = DataProvider.class.getName();

    @GET
    @Produces(value={"application/xml", "application/json"})
    public ResultSlice<DataProvider> getProviders(@QueryParam(value="from") String startFrom) {
        return this.providerService.getProviders(startFrom, this.numberOfElementsOnPage);
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    @PreAuthorize(value="isAuthenticated()")
    public Response createProvider(@Context UriInfo uriInfo, DataProviderProperties dataProviderProperties, @QueryParam(value="providerId") String providerId) throws ProviderAlreadyExistsException {
        DataProvider provider = this.providerService.createProvider(providerId, dataProviderProperties);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (DataProvider)provider);
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl providerIdentity = new ObjectIdentityImpl(this.DATA_PROVIDER_CLASS_NAME, (Serializable)((Object)providerId));
            MutableAcl providerAcl = this.mutableAclService.createAcl((ObjectIdentity)providerIdentity);
            providerAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
            this.mutableAclService.updateAcl(providerAcl);
        }
        return Response.created((URI)provider.getUri()).build();
    }
}

