/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.UniqueIdentifierService;
import eu.europeana.cloud.service.uis.exception.CloudIdAlreadyExistException;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.exception.RecordIdDoesNotExistException;
import eu.europeana.cloud.service.uis.rest.EnrichUriUtil;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.ChildrenExistException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}")
@Component
@Scope(value="request")
public class DataProviderResource {
    @Autowired
    private UniqueIdentifierService uniqueIdentifierService;
    @Autowired
    private DataProviderService providerService;
    @Autowired
    private MutableAclService mutableAclService;
    protected final String LOCAL_ID_CLASS_NAME = "LocalId";

    @GET
    @Produces(value={"application/xml", "application/json"})
    public DataProvider getProvider(@PathParam(value="DATAPROVIDER") String providerId) throws ProviderDoesNotExistException {
        return this.providerService.getProvider(providerId);
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @PreAuthorize(value="hasPermission(#providerId, 'eu.europeana.cloud.common.model.DataProvider', write)")
    public void updateProvider(DataProviderProperties dataProviderProperties, @PathParam(value="DATAPROVIDER") String providerId, @Context UriInfo uriInfo) throws ProviderDoesNotExistException {
        DataProvider provider = this.providerService.updateProvider(providerId, dataProviderProperties);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (DataProvider)provider);
    }

    @DELETE
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Response deleteProvider(@PathParam(value="DATAPROVIDER") String dataProviderId) throws ProviderDoesNotExistException {
        this.providerService.deleteProvider(dataProviderId);
        this.deleteProviderAcl(dataProviderId);
        return Response.ok().build();
    }

    @GET
    @Path(value="localIds")
    @Produces(value={"application/json", "application/xml"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.CloudId>")
    public Response getLocalIdsByProvider(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="from") String from, @QueryParam(value="to") @DefaultValue(value="10000") int to) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        ResultSlice pList = new ResultSlice();
        pList.setResults(this.uniqueIdentifierService.getLocalIdsByProvider(providerId, from, to));
        if (pList.getResults().size() == to) {
            pList.setNextSlice(((CloudId)pList.getResults().get(to - 1)).getId());
        }
        return Response.ok((Object)pList).build();
    }

    @GET
    @Path(value="cloudIds")
    @Produces(value={"application/json", "application/xml"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<eu.europeana.cloud.common.model.CloudId>")
    public Response getCloudIdsByProvider(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="from") String from, @QueryParam(value="to") @DefaultValue(value="10000") int to) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        ResultSlice pList = new ResultSlice();
        pList.setResults(this.uniqueIdentifierService.getCloudIdsByProvider(providerId, from, to));
        if (pList.getResults().size() == to) {
            pList.setNextSlice(((CloudId)pList.getResults().get(to - 1)).getId());
        }
        return Response.ok((Object)pList).build();
    }

    @POST
    @Path(value="cloudIds/{CLOUDID}")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="isAuthenticated()")
    @ReturnType(value="eu.europeana.cloud.common.model.CloudId")
    public Response createIdMapping(@PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="CLOUDID") String cloudId, @QueryParam(value="recordId") String localId) throws DatabaseConnectionException, CloudIdDoesNotExistException, IdHasBeenMappedException, ProviderDoesNotExistException, RecordDatasetEmptyException, CloudIdAlreadyExistException {
        CloudId result = null;
        result = localId != null ? this.uniqueIdentifierService.createIdMapping(cloudId, providerId, localId) : this.uniqueIdentifierService.createIdMapping(cloudId, providerId);
        this.grantPermissionsToLocalId(result, providerId);
        return Response.ok().entity((Object)result).build();
    }

    protected void grantPermissionsToLocalId(CloudId result, String providerId) throws NotFoundException, AlreadyExistsException {
        String creatorName = SpringUserUtils.getUsername();
        String key = result.getLocalId().getRecordId() + "/" + providerId;
        if (creatorName != null) {
            ObjectIdentityImpl providerIdentity = new ObjectIdentityImpl("LocalId", (Serializable)((Object)key));
            MutableAcl providerAcl = this.mutableAclService.createAcl((ObjectIdentity)providerIdentity);
            providerAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
            providerAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
            this.mutableAclService.updateAcl(providerAcl);
        }
    }

    @DELETE
    @Path(value="localIds/{LOCALID}")
    @Produces(value={"application/json", "application/xml"})
    @PreAuthorize(value="hasPermission(#localId.concat('/').concat(#providerId),'LocalId', write)")
    public Response removeIdMapping(@PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="LOCALID") String localId) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordIdDoesNotExistException {
        this.uniqueIdentifierService.removeIdMapping(providerId, localId);
        this.deleteLocalIdAcl(localId, providerId);
        return Response.ok((Object)"Mapping marked as deleted").build();
    }

    protected void deleteLocalIdAcl(String localId, String providerId) throws ChildrenExistException {
        String key = localId + "/" + providerId;
        ObjectIdentityImpl providerIdentity = new ObjectIdentityImpl("LocalId", (Serializable)((Object)key));
        this.mutableAclService.deleteAcl((ObjectIdentity)providerIdentity, false);
    }

    private void deleteProviderAcl(String dataProviderId) {
        ObjectIdentityImpl providerIdentity = new ObjectIdentityImpl(DataProvider.class.getName(), (Serializable)((Object)dataProviderId));
        this.mutableAclService.deleteAcl((ObjectIdentity)providerIdentity, false);
    }
}

