/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.uis.DataProviderService;
import eu.europeana.cloud.service.uis.UniqueIdentifierService;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.exception.RecordIdDoesNotExistException;
import eu.europeana.cloud.service.uis.rest.EnrichUriUtil;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}")
@Component
@Scope(value="request")
public class DataProviderResource {
    @Autowired
    private UniqueIdentifierService uniqueIdentifierService;
    @Autowired
    private DataProviderService providerService;
    @PathParam(value="LOCALID")
    private String localId;
    @PathParam(value="CLOUDID")
    private String cloudId;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public DataProvider getProvider(@PathParam(value="DATAPROVIDER") String providerId) throws ProviderDoesNotExistException {
        return this.providerService.getProvider(providerId);
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @PreAuthorize(value="hasPermission(#providerId, 'eu.europeana.cloud.common.model.DataProvider', write)")
    public void updateProvider(DataProviderProperties dataProviderProperties, @PathParam(value="DATAPROVIDER") String providerId, @Context UriInfo uriInfo) throws ProviderDoesNotExistException {
        DataProvider provider = this.providerService.updateProvider(providerId, dataProviderProperties);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (DataProvider)provider);
    }

    @GET
    @Path(value="localIds")
    @Produces(value={"application/json", "application/xml"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice")
    public Response getLocalIdsByProvider(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="from") String from, @QueryParam(value="to") @DefaultValue(value="10000") int to) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        ResultSlice pList = new ResultSlice();
        pList.setResults(this.uniqueIdentifierService.getLocalIdsByProvider(providerId, from, to));
        if (pList.getResults().size() == to) {
            pList.setNextSlice(((CloudId)pList.getResults().get(to - 1)).getId());
        }
        return Response.ok((Object)pList).build();
    }

    @GET
    @Path(value="cloudIds")
    @Produces(value={"application/json", "application/xml"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice")
    public Response getCloudIdsByProvider(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="from") String from, @QueryParam(value="to") @DefaultValue(value="10000") int to) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        ResultSlice pList = new ResultSlice();
        pList.setResults(this.uniqueIdentifierService.getCloudIdsByProvider(providerId, from, to));
        if (pList.getResults().size() == to) {
            pList.setNextSlice(((CloudId)pList.getResults().get(to - 1)).getId());
        }
        return Response.ok((Object)pList).build();
    }

    @POST
    @Path(value="cloudIds/{CLOUDID}")
    @Produces(value={"application/json", "application/xml"})
    public Response createIdMapping(@PathParam(value="DATAPROVIDER") String providerId, @QueryParam(value="recordId") String localId) throws DatabaseConnectionException, CloudIdDoesNotExistException, IdHasBeenMappedException, ProviderDoesNotExistException, RecordDatasetEmptyException {
        if (localId != null) {
            return Response.ok().entity((Object)this.uniqueIdentifierService.createIdMapping(this.cloudId, providerId, localId)).build();
        }
        return Response.ok().entity((Object)this.uniqueIdentifierService.createIdMapping(this.cloudId, providerId)).build();
    }

    @DELETE
    @Path(value="localIds/{LOCALID}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeIdMapping(@PathParam(value="DATAPROVIDER") String providerId) throws DatabaseConnectionException, ProviderDoesNotExistException, RecordIdDoesNotExistException {
        this.uniqueIdentifierService.removeIdMapping(providerId, this.localId);
        return Response.ok((Object)"Mapping marked as deleted").build();
    }
}

