/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.linkedlist.ExposedNodeLinkedList;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.WeakCacheKey;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class HardCacheWeakIdentityMap
extends WeakIdentityMap {
    protected ExposedNodeLinkedList referenceCache = new ExposedNodeLinkedList();

    public HardCacheWeakIdentityMap(int size, ClassDescriptor descriptor, AbstractSession session, boolean isIsolated) {
        super(size, descriptor, session, isIsolated);
    }

    @Override
    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new ReferenceCacheKey(primaryKey, object, writeLockValue, readTime, this.isIsolated);
    }

    public ExposedNodeLinkedList getReferenceCache() {
        return this.referenceCache;
    }

    public Object buildReference(Object object) {
        return object;
    }

    public boolean hasReference(Object reference) {
        return reference != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        LinkedNode node = ((ReferenceCacheKey)cacheKey).getReferenceCacheNode();
        if (node != null) {
            ExposedNodeLinkedList exposedNodeLinkedList = this.referenceCache;
            synchronized (exposedNodeLinkedList) {
                this.referenceCache.remove(node);
            }
        }
        return super.remove(cacheKey);
    }

    @Override
    public CacheKey put(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        CacheKey cacheKey = super.put(primaryKey, object, writeLockValue, readTime);
        cacheKey.updateAccess();
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateMaxSize(int maxSize) {
        this.setMaxSize(maxSize);
        ExposedNodeLinkedList exposedNodeLinkedList = this.referenceCache;
        synchronized (exposedNodeLinkedList) {
            while (this.referenceCache.size() > this.maxSize) {
                this.referenceCache.removeLast();
            }
        }
    }

    public class ReferenceCacheKey
    extends WeakCacheKey {
        protected LinkedNode referenceNode;

        public ReferenceCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime, boolean isIsolated) {
            super(primaryKey, object, writeLockValue, readTime, isIsolated);
        }

        public LinkedNode getReferenceCacheNode() {
            return this.referenceNode;
        }

        public void setReferenceCacheNode(LinkedNode referenceNode) {
            this.referenceNode = referenceNode;
        }

        public ExposedNodeLinkedList getReferenceCache() {
            return HardCacheWeakIdentityMap.this.referenceCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateAccess() {
            if (this.referenceNode != null && !HardCacheWeakIdentityMap.this.hasReference(this.referenceNode.getContents())) {
                this.referenceNode.setContents(HardCacheWeakIdentityMap.this.buildReference(this.getObject()));
            }
            ExposedNodeLinkedList exposedNodeLinkedList = HardCacheWeakIdentityMap.this.referenceCache;
            synchronized (exposedNodeLinkedList) {
                if (this.referenceNode == null) {
                    this.referenceNode = HardCacheWeakIdentityMap.this.referenceCache.addFirst(HardCacheWeakIdentityMap.this.buildReference(this.getObject()));
                } else {
                    HardCacheWeakIdentityMap.this.referenceCache.moveFirst(this.getReferenceCacheNode());
                }
                while (HardCacheWeakIdentityMap.this.referenceCache.size() > HardCacheWeakIdentityMap.this.maxSize) {
                    HardCacheWeakIdentityMap.this.referenceCache.removeLast();
                }
            }
        }
    }
}

