/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest.console.commands.tests;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.client.uis.rest.console.commands.Command;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProviderProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.naming.directory.InvalidAttributesException;
import org.apache.commons.io.IOUtils;

public class TestCreateMappingIdOneProviderCommand
extends Command {
    @Override
    public void execute(UISClient client, int threadNo, String ... input) throws InvalidAttributesException {
        String providerId = input[1] + threadNo;
        String recordId = input[2];
        try {
            client.createProvider(providerId + "initial1", new DataProviderProperties());
            client.createProvider(providerId, new DataProviderProperties());
            CloudId cId = client.createCloudId(providerId + "initial1", recordId + "initial1");
            long i = 0L;
            ArrayList<String> str = new ArrayList<String>();
            Date now = new Date();
            long start = now.getTime();
            System.out.println("Test started at: " + now);
            while (i < Long.parseLong(input[0])) {
                client.createMapping(cId.getId(), providerId, recordId + i);
                str.add(String.format("%s %s %s", cId.getId(), providerId, recordId + i));
                if (++i % 1000L != 0L) continue;
                System.out.println("Added " + i / 1000L + " records");
            }
            long end = new Date().getTime() - start;
            System.out.println("Adding " + input[0] + " records took " + end + " ms");
            System.out.println("Average: " + Double.parseDouble(input[0]) / (double)end * 1000.0 + " records per second");
            IOUtils.writeLines(str, "\n", new FileOutputStream(new File(input[3])));
        }
        catch (CloudException | IOException e) {
            this.getLogger().error(e.getMessage());
        }
    }
}

