/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.common.model.dps;

import eu.europeana.cloud.common.model.dps.AttributeStatistics;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class NodeStatistics {
    private String parentXpath;
    private String xpath;
    private String value;
    private long occurrence;
    private Set<AttributeStatistics> attributesStatistics = new HashSet<AttributeStatistics>();

    public NodeStatistics() {
    }

    public NodeStatistics(String parentXpath, String xpath, String value, long occurrence) {
        this(parentXpath, xpath, value, occurrence, new HashSet<AttributeStatistics>());
    }

    public NodeStatistics(String parentXpath, String xpath, String value, long occurrence, Set<AttributeStatistics> attributesStatistics) {
        this.parentXpath = parentXpath == null ? "" : parentXpath;
        this.xpath = xpath;
        this.value = value;
        this.occurrence = occurrence <= 0L ? 1L : occurrence;
        this.attributesStatistics = attributesStatistics;
    }

    public String getParentXpath() {
        return this.parentXpath;
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getValue() {
        return this.value;
    }

    public long getOccurrence() {
        return this.occurrence;
    }

    public void increaseOccurrence() {
        ++this.occurrence;
    }

    public Set<AttributeStatistics> getAttributesStatistics() {
        return this.attributesStatistics;
    }

    public void setAttributesStatistics(Set<AttributeStatistics> attributesStatistics) {
        this.attributesStatistics = attributesStatistics;
    }

    public void setParentXpath(String parentXpath) {
        this.parentXpath = parentXpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setOccurrence(long occurrence) {
        this.occurrence = occurrence;
    }

    public boolean hasAttributes() {
        return !this.attributesStatistics.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeStatistics)) {
            return false;
        }
        NodeStatistics nodeStatistics = (NodeStatistics)o;
        return nodeStatistics.getParentXpath().equals(this.parentXpath) && nodeStatistics.getValue().equals(this.value) && nodeStatistics.getXpath().equals(this.xpath) && nodeStatistics.getAttributesStatistics().equals(this.attributesStatistics);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.parentXpath.hashCode();
        result = 31 * result + this.xpath.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.attributesStatistics.hashCode();
        return result;
    }
}

