/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest.zookeeper;

import com.google.common.base.Throwables;
import eu.europeana.cloud.client.uis.rest.zookeeper.ServiceFinder;
import eu.europeana.cloud.service.coordination.ServiceProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.EnsurePath;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperService.class);
    private final CuratorFramework curatorFramework;
    private static final int ZOOKEEPER_CONNECTION_TIMEOUT = 60000;
    private static final int ZOOKEEPER_SESSION_TIMEOUT = 60000;
    private final ServiceFinder serviceFinder;
    private static final RetryPolicy ZOOKEEPER_RETRY_POLICY = new ExponentialBackoffRetry(1000, 3);

    public ZookeeperService() throws IOException {
        LOGGER.info("ZookeeperService starting...");
        String zookeeperAddress = this.getZookeeperAddress();
        LOGGER.info("ZookeeperService using Zookeeper Address='{}'", (Object)zookeeperAddress);
        String zNode = this.getZookeeperZNode();
        LOGGER.info("ZookeeperService using zookeeper zNode='{}'", (Object)zNode);
        this.curatorFramework = CuratorFrameworkFactory.builder().connectionTimeoutMs(60000).retryPolicy(ZOOKEEPER_RETRY_POLICY).sessionTimeoutMs(60000).connectString(zookeeperAddress).build();
        this.curatorFramework.start();
        try {
            new EnsurePath(zNode).ensure(this.curatorFramework.getZookeeperClient());
        }
        catch (Exception e) {
            LOGGER.error("ZooKeeper zNode='{}' not found... Exception='{}'", (Object)zNode, (Object)e.getMessage());
            throw Throwables.propagate(e);
        }
        this.serviceFinder = new ServiceFinder(this.curatorFramework, new JsonInstanceSerializer<ServiceProperties>(ServiceProperties.class), zNode);
        LOGGER.info("ZookeeperService started successfully.");
    }

    public ServiceFinder getServiceFinder() {
        return this.serviceFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getZookeeperAddress() throws IOException {
        Properties props = new Properties();
        try (InputStream is = null;){
            is = new FileInputStream(new File("src/main/resources/client.properties"));
            props.load(is);
            String string = props.getProperty("zookeeper.URL");
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getZookeeperZNode() throws IOException {
        Properties props = new Properties();
        try (InputStream is = null;){
            is = new FileInputStream(new File("src/main/resources/client.properties"));
            props.load(is);
            String string = props.getProperty("zookeeper.ZNODE");
            return string;
        }
        return null;
    }
}

