/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.ExceptionMapperFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.JerseyErrorService;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.JerseyClassAnalyzer;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SecurityContextInjectee;
import org.glassfish.jersey.internal.spi.AutoDiscoverable;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ChunkedResponseWriter;
import org.glassfish.jersey.server.ContainerFilteringStage;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.DefaultRespondingContext;
import org.glassfish.jersey.server.ProcessingBinder;
import org.glassfish.jersey.server.ReferencesInitializer;
import org.glassfish.jersey.server.internal.JerseyResourceContext;
import org.glassfish.jersey.server.internal.JsonWithPaddingInterceptor;
import org.glassfish.jersey.server.internal.MappableExceptionWrapperInterceptor;
import org.glassfish.jersey.server.internal.ProcessingProviders;
import org.glassfish.jersey.server.internal.RuntimeExecutorsBinder;
import org.glassfish.jersey.server.internal.inject.CloseableServiceBinder;
import org.glassfish.jersey.server.internal.inject.ParameterInjectionBinder;
import org.glassfish.jersey.server.internal.monitoring.MonitoringContainerListener;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.RouterBinder;
import org.glassfish.jersey.server.model.internal.ResourceModelBinder;
import org.glassfish.jersey.server.spi.ContainerProvider;

class ServerBinder
extends AbstractBinder {
    private final Map<String, Object> applicationProperties;

    public ServerBinder(Map<String, Object> applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    protected void configure() {
        this.install(new RequestScope.Binder(), new JerseyErrorService.Binder(), new ProcessingBinder(), new ContextInjectionResolver.Binder(), new ParameterInjectionBinder(), new JerseyClassAnalyzer.Binder(), new MessagingBinders.MessageBodyProviders(this.applicationProperties, RuntimeType.SERVER), new MessageBodyFactory.Binder(), new ExceptionMapperFactory.Binder(), new ContextResolverFactory.Binder(), new JaxrsProviders.Binder(), new ProcessingProviders.Binder(), new ContainerFilteringStage.Binder(), new ResourceModelBinder(), new RuntimeExecutorsBinder(), new RouterBinder(), new ServiceFinderBinder<ContainerProvider>(ContainerProvider.class, this.applicationProperties, RuntimeType.SERVER), new CloseableServiceBinder(), new JerseyResourceContext.Binder(), new ServiceFinderBinder<AutoDiscoverable>(AutoDiscoverable.class, this.applicationProperties, RuntimeType.SERVER), new MappableExceptionWrapperInterceptor.Binder(), new MonitoringContainerListener.Binder());
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ContainerRequest.class).in(RequestScoped.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ContainerRequestContext.class).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<ContainerRequest>>(){}).in(RequestScoped.class);
        this.bind(DefaultRespondingContext.class).to(RespondingContext.class).in(RequestScoped.class);
        this.bind(ChunkedResponseWriter.class).to(MessageBodyWriter.class).in(Singleton.class);
        this.bind(JsonWithPaddingInterceptor.class).to(WriterInterceptor.class).in(Singleton.class);
        this.bindAsContract(ReferencesInitializer.class);
        this.bindFactory(UriInfoReferencingFactory.class).to(UriInfo.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<UriInfo>>(){}).in(RequestScoped.class);
        this.bindFactory(HttpHeadersReferencingFactory.class).to(HttpHeaders.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpHeaders>>(){}).in(RequestScoped.class);
        this.bindFactory(RequestReferencingFactory.class).to(Request.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<Request>>(){}).in(RequestScoped.class);
        this.bindAsContract(SecurityContextInjectee.class).to(SecurityContext.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
    }

    private static class RequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public RequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpHeadersReferencingFactory
    extends ReferencingFactory<HttpHeaders> {
        @Inject
        public HttpHeadersReferencingFactory(Provider<Ref<HttpHeaders>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class UriInfoReferencingFactory
    extends ReferencingFactory<UriInfo> {
        @Inject
        public UriInfoReferencingFactory(Provider<Ref<UriInfo>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ContainerRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ContainerRequest>> referenceFactory) {
            super(referenceFactory);
        }

        @Override
        @RequestScoped
        public ContainerRequest provide() {
            return (ContainerRequest)super.provide();
        }
    }
}

