/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest.web;

import eu.europeana.cloud.client.uis.rest.web.UrlProvider;
import eu.europeana.cloud.service.coordination.ZookeeperService;
import eu.europeana.cloud.service.coordination.discovery.EcloudServiceDiscovery;
import eu.europeana.cloud.service.coordination.discovery.ZookeeperServiceDiscovery;
import eu.europeana.cloud.service.coordination.provider.ServiceProvider;
import eu.europeana.cloud.service.coordination.provider.ServiceProviderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicUrlProvider
implements UrlProvider {
    private ServiceProvider provider;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicUrlProvider.class);
    private static final int CONNECTION_TIMEOUT = 3000;
    private static final int SESSION_TIMEOUT = 3000;
    private static final String UIS_SERVICE_KEY = "UIS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicUrlProvider() throws IOException {
        LOGGER.info("DynamicUrlProvider: Starting UrlProvider, no URL provided");
        String zkAddress = null;
        String preferredDatacenter = null;
        String serviceDiscoveryPath = null;
        Properties props = new Properties();
        try (InputStream is = null;){
            is = new FileInputStream(new File("src/main/resources/client.properties"));
            props.load(is);
            zkAddress = props.getProperty("coordination.service.URL");
            preferredDatacenter = props.getProperty("coordination.service.PREFERRED_DATACENTER");
            serviceDiscoveryPath = props.getProperty("coordination.service.SERVICE_DISCOVERY_PATH");
        }
        ZookeeperService zS = new ZookeeperService(zkAddress, 3000, 3000, serviceDiscoveryPath);
        ZookeeperServiceDiscovery serviceDiscovery = new ZookeeperServiceDiscovery(zS, "/discovery", UIS_SERVICE_KEY);
        this.provider = new ServiceProviderImpl((EcloudServiceDiscovery)serviceDiscovery, preferredDatacenter);
        LOGGER.info("DynamicUrlProvider: UrlProvider started successfully");
    }

    public DynamicUrlProvider(String zkAddress, String serviceDiscoveryPath, String preferredDatacenter) {
        LOGGER.info("DynamicUrlProvider: Starting UrlProvider {}:{}:{}", new Object[]{zkAddress, serviceDiscoveryPath, preferredDatacenter});
        ZookeeperService zS = new ZookeeperService(zkAddress, 3000, 3000, serviceDiscoveryPath);
        ZookeeperServiceDiscovery serviceDiscovery = new ZookeeperServiceDiscovery(zS, serviceDiscoveryPath, UIS_SERVICE_KEY);
        this.provider = new ServiceProviderImpl((EcloudServiceDiscovery)serviceDiscovery, preferredDatacenter);
        LOGGER.info("DynamicUrlProvider: UrlProvider started successfully.");
    }

    public DynamicUrlProvider(ServiceProvider provider) {
        LOGGER.info("DynamicUrlProvider: Starting UrlProvider...");
        this.provider = provider;
        LOGGER.info("DynamicUrlProvider: UrlProvider started successfully.");
    }

    @Override
    public String getBaseUrl() {
        String address = this.provider.getService().getListenAddress();
        LOGGER.info("DynamicUrlProvider: using url: {}", (Object)address);
        return address;
    }
}

