/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest.console.commands.tests;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.UISClient;
import eu.europeana.cloud.client.uis.rest.console.commands.Command;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.LocalId;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.naming.directory.InvalidAttributesException;
import org.apache.commons.io.FileUtils;

public class TestRetrieveLocalIdWithPaginationCommand
extends Command {
    @Override
    public void execute(UISClient client, int threadNo, String ... input) throws InvalidAttributesException {
        try {
            List ids = FileUtils.readLines((File)new File(input[1]));
            String[] columns = ((String)ids.get(0)).split(" ");
            List cloudIds = client.getCloudIdsByProvider(columns[1]).getResults();
            int window = Integer.parseInt(input[0]);
            Date now = new Date();
            System.out.println("Starting test at: " + now.toString());
            List paginated = client.getRecordIdsByProviderWithPagination(columns[1], ((CloudId)cloudIds.get(0)).getLocalId().getRecordId(), window).getResults();
            while (paginated.size() == window) {
                List paginated2;
                paginated = paginated2 = client.getRecordIdsByProviderWithPagination(columns[1], ((LocalId)paginated.get(19)).getRecordId(), window).getResults();
            }
            long end = new Date().getTime() - now.getTime();
            System.out.println("Fetching " + cloudIds.size() + " records " + window + " took " + end + " ms");
            System.out.println("Average: " + (long)cloudIds.size() / end * 1000L + " records per second");
        }
        catch (CloudException | IOException e) {
            this.getLogger().error(e.getMessage());
        }
    }
}

