/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.client.uis.rest.web.DynamicUrlProvider;
import eu.europeana.cloud.client.uis.rest.web.StaticUrlProvider;
import eu.europeana.cloud.client.uis.rest.web.UrlProvider;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.DataProvider;
import eu.europeana.cloud.common.model.DataProviderProperties;
import eu.europeana.cloud.common.model.LocalId;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.coordination.provider.ServiceProvider;
import eu.europeana.cloud.service.uis.status.IdentifierErrorTemplate;
import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UISClient {
    private Client client = JerseyClientBuilder.newClient();
    private UrlProvider urlProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(UISClient.class);

    public UISClient() {
        LOGGER.info("UISClient starting... no UIS-URL provided.");
        try {
            this.urlProvider = new DynamicUrlProvider();
        }
        catch (IOException e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(String username, String password) {
        LOGGER.info("UISClient starting... no UIS-URL provided.");
        try {
            this.urlProvider = new DynamicUrlProvider();
        }
        catch (IOException e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(ServiceProvider uisProvider) {
        LOGGER.info("UISClient starting...");
        try {
            this.urlProvider = new DynamicUrlProvider(uisProvider);
        }
        catch (Exception e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(ServiceProvider uisProvider, String username, String password) {
        LOGGER.info("UISClient starting...");
        this.client.register((Object)new HttpBasicAuthFilter(username, password));
        try {
            this.urlProvider = new DynamicUrlProvider(uisProvider);
        }
        catch (Exception e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(String uisUrl, String username, String password) {
        LOGGER.info("UISClient starting...");
        this.client.register((Object)new HttpBasicAuthFilter(username, password));
        try {
            this.urlProvider = new StaticUrlProvider(uisUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public UISClient(String uisUrl) {
        LOGGER.info("UISClient starting...");
        try {
            this.urlProvider = new StaticUrlProvider(uisUrl);
        }
        catch (Exception e) {
            LOGGER.error("Error while starting UISClient... Could not start UrlProvider.. {}", (Object)e.getMessage());
        }
        LOGGER.info("UISClient started successfully.");
    }

    public CloudId createCloudId(String providerId, String recordId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/cloudIds").queryParam("providerId", new Object[]{providerId}).queryParam("recordId", new Object[]{recordId}).request().post(null);
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (CloudId)resp.readEntity(CloudId.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public CloudId createCloudId(String providerId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/cloudIds").queryParam("providerId", new Object[]{providerId}).request().post(null);
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (CloudId)resp.readEntity(CloudId.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public CloudId getCloudId(String providerId, String recordId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/cloudIds").queryParam("providerId", new Object[]{providerId}).queryParam("recordId", new Object[]{recordId}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (CloudId)resp.readEntity(CloudId.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<CloudId> getRecordId(String cloudId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/cloudIds/{CLOUD_ID}").resolveTemplate("CLOUD_ID", (Object)cloudId).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<LocalId> getRecordIdsByProvider(String providerId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/localIds").resolveTemplate("PROVIDER_ID", (Object)providerId).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<CloudId> getCloudIdsByProvider(String providerId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/cloudIds").resolveTemplate("PROVIDER_ID", (Object)providerId).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<LocalId> getRecordIdsByProviderWithPagination(String providerId, String recordId, int window) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/localIds").resolveTemplate("PROVIDER_ID", (Object)providerId).queryParam("from", new Object[]{recordId}).queryParam("to", new Object[]{window}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<CloudId> getCloudIdsByProviderWithPagination(String providerId, String cloudId, int window) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/cloudIds").resolveTemplate("PROVIDER_ID", (Object)providerId).queryParam("from", new Object[]{cloudId}).queryParam("to", new Object[]{window}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public boolean createMapping(String cloudId, String providerId, String recordId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/cloudIds/{CLOUD_ID}").resolveTemplate("PROVIDER_ID", (Object)providerId).resolveTemplate("CLOUD_ID", (Object)cloudId).queryParam("recordId", new Object[]{recordId}).request().post(null);
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return true;
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public boolean removeMappingByLocalId(String providerId, String recordId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}/localIds/{LOCAL_ID}").resolveTemplate("PROVIDER_ID", (Object)providerId).resolveTemplate("LOCAL_ID", (Object)recordId).request().delete();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return true;
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public boolean deleteCloudId(String cloudId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/cloudIds/{CLOUD_ID}").resolveTemplate("CLOUD_ID", (Object)cloudId).request().delete();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return true;
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public String createProvider(String providerId, DataProviderProperties dp) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers").queryParam("providerId", new Object[]{providerId}).request().post(Entity.json((Object)dp));
        if (resp.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return resp.toString();
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public boolean updateProvider(String providerId, DataProviderProperties dp) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}").resolveTemplate("PROVIDER_ID", (Object)providerId).request().put(Entity.json((Object)dp));
        if (resp.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
            return true;
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public ResultSlice<DataProvider> getDataProviders(String from) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers").queryParam("from", new Object[]{from}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (ResultSlice)resp.readEntity(ResultSlice.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public DataProvider getDataProvider(String providerId) throws CloudException {
        Response resp = this.client.target(this.urlProvider.getBaseUrl() + "/data-providers/{PROVIDER_ID}").resolveTemplate("PROVIDER_ID", (Object)providerId).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            return (DataProvider)resp.readEntity(DataProvider.class);
        }
        throw this.generateException((ErrorInfo)resp.readEntity(ErrorInfo.class));
    }

    public CloudException generateException(ErrorInfo e) {
        IdentifierErrorTemplate error = IdentifierErrorTemplate.valueOf((String)e.getErrorCode());
        LOGGER.error(e.getDetails());
        return new CloudException(e.getErrorCode(), error.getException(e));
    }
}

