/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.client.uis.rest.zookeeper;

import com.google.common.base.Throwables;
import eu.europeana.cloud.service.coordination.ServiceProperties;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.strategies.RandomStrategy;
import org.apache.curator.x.discovery.strategies.RoundRobinStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFinder {
    private final ServiceDiscovery<ServiceProperties> discovery;
    private static final String SERVICE_NAME = "UIS";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceFinder.class);

    public ServiceFinder(CuratorFramework curatorFramework, InstanceSerializer<ServiceProperties> instanceSerializer, String zookeeperRegistrationPath) {
        this.discovery = ServiceDiscoveryBuilder.builder(ServiceProperties.class).basePath(zookeeperRegistrationPath).client(curatorFramework).serializer(instanceSerializer).build();
        try {
            this.discovery.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ServiceInstance<ServiceProperties> getRandomService() {
        return this.getService((ProviderStrategy<ServiceProperties>)new RandomStrategy());
    }

    public ServiceInstance<ServiceProperties> getRoundRobinService() {
        return this.getService((ProviderStrategy<ServiceProperties>)new RoundRobinStrategy());
    }

    public ServiceInstance<ServiceProperties> getService() {
        return this.getRoundRobinService();
    }

    private ServiceInstance<ServiceProperties> getService(ProviderStrategy<ServiceProperties> loadBalancingStrategy) {
        try {
            ServiceProvider serviceProvider = this.discovery.serviceProviderBuilder().serviceName(SERVICE_NAME).providerStrategy(loadBalancingStrategy).build();
            serviceProvider.start();
            return serviceProvider.getInstance();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Collection<ServiceInstance<ServiceProperties>> getServiceInstances(String serviceName) {
        Collection instances;
        try {
            instances = this.discovery.queryForInstances(serviceName);
            int servicesDiscoveredCount = instances.size();
            LOGGER.info("Found '{}' services: {} .", (Object)servicesDiscoveredCount, (Object)instances);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
        return instances;
    }

    public Collection<ServiceInstance<ServiceProperties>> getServiceInstances() {
        return this.getServiceInstances(SERVICE_NAME);
    }
}

