/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.ws.rs.container.ResourceContext;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.ResourceModel;

public class JerseyResourceContext
implements ExtendedResourceContext {
    private final ServiceLocator locator;
    private final Set<Class<?>> bindingCache;
    private final Object bindingCacheLock;
    private volatile ResourceModel resourceModel;

    @Inject
    JerseyResourceContext(ServiceLocator locator) {
        this.locator = locator;
        this.bindingCache = Sets.newIdentityHashSet();
        this.bindingCacheLock = new Object();
    }

    @Override
    public <T> T getResource(Class<T> resourceClass) {
        try {
            return Injections.getOrCreate(this.locator, resourceClass);
        }
        catch (Exception ex) {
            Logger.getLogger(JerseyResourceContext.class.getName()).log(Level.WARNING, LocalizationMessages.RESOURCE_LOOKUP_FAILED(resourceClass), ex);
            return null;
        }
    }

    @Override
    public <T> T initResource(T resource) {
        this.locator.inject(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void bindResource(Class<T> resourceClass) {
        if (this.bindingCache.contains(resourceClass)) {
            return;
        }
        Object object = this.bindingCacheLock;
        synchronized (object) {
            if (this.bindingCache.contains(resourceClass)) {
                return;
            }
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            this.unsafeBindResource(resourceClass, null, dc);
            dc.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindResourceIfSingleton(Object resource) {
        Class<?> resourceClass = resource.getClass();
        if (this.bindingCache.contains(resourceClass)) {
            return;
        }
        Object object = this.bindingCacheLock;
        synchronized (object) {
            if (this.bindingCache.contains(resourceClass)) {
                return;
            }
            if (JerseyResourceContext.getScope(resourceClass) == Singleton.class) {
                DynamicConfiguration dc = Injections.getConfiguration(this.locator);
                Injections.addBinding(Injections.newBinder(resource).to(resourceClass), dc);
                dc.commit();
            }
            this.bindingCache.add(resourceClass);
        }
    }

    public void unsafeBindResource(Object resource, ContractProvider providerModel, DynamicConfiguration dc) {
        Class<?> resourceClass = resource.getClass();
        if (providerModel != null) {
            Class<? extends Annotation> scope = providerModel.getScope();
            ActiveDescriptor descriptor = dc.bind(BuilderHelper.createConstantDescriptor(resource, null, resourceClass));
            for (Class<?> contract : Providers.getProviderContracts(resourceClass)) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(this.locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.addQualifierAnnotation(new CustomAnnotationImpl());
                dc.bind(aliasDescriptor);
            }
        } else {
            Injections.addBinding(Injections.newBinder(resourceClass).to(resourceClass).in(JerseyResourceContext.getScope(resourceClass)), dc);
        }
        this.bindingCache.add(resourceClass);
    }

    private static Class<? extends Annotation> getScope(Class<?> resourceClass) {
        Collection<Class<? extends Annotation>> scopes = ReflectionHelper.getAnnotationTypes(resourceClass, Scope.class);
        return scopes.isEmpty() ? RequestScoped.class : scopes.iterator().next();
    }

    public <T> void unsafeBindResource(Class<T> resourceClass, ContractProvider providerModel, DynamicConfiguration dc) {
        if (providerModel != null) {
            Class<? extends Annotation> scope = providerModel.getScope();
            ActiveDescriptor descriptor = dc.bind(BuilderHelper.activeLink(resourceClass).to(resourceClass).in(scope).build());
            for (Class<?> contract : providerModel.getContracts()) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(this.locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.setRanking(providerModel.getPriority(contract));
                aliasDescriptor.addQualifierAnnotation(new CustomAnnotationImpl());
                dc.bind(aliasDescriptor);
            }
        } else {
            Injections.addBinding(Injections.newBinder(resourceClass).to(resourceClass).in(JerseyResourceContext.getScope(resourceClass)), dc);
        }
        this.bindingCache.add(resourceClass);
    }

    @Override
    public ResourceModel getResourceModel() {
        return this.resourceModel;
    }

    public void setResourceModel(ResourceModel resourceModel) {
        this.resourceModel = resourceModel;
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bindAsContract(JerseyResourceContext.class).to(ResourceContext.class).to(ExtendedResourceContext.class).in(Singleton.class);
        }
    }
}

