/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.message.filtering.spi.EntityGraph;
import org.glassfish.jersey.message.filtering.spi.ObjectGraph;
import org.glassfish.jersey.message.filtering.spi.ScopeProvider;

final class ObjectGraphImpl
implements ObjectGraph {
    private final Set<String> filteringScopes;
    private final Map<Class<?>, EntityGraph> classToGraph;
    private final EntityGraph graph;
    private Set<String> fields;
    private Map<String, ObjectGraph> subgraphs;

    ObjectGraphImpl(Map<Class<?>, EntityGraph> classToGraph, EntityGraph graph, Set<String> filteringScopes) {
        this.filteringScopes = filteringScopes;
        this.classToGraph = classToGraph;
        this.graph = graph;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.graph.getEntityClass();
    }

    @Override
    public Set<String> getFields() {
        if (this.fields == null) {
            this.fields = this.graph.getFields(Sets.union(this.filteringScopes, Collections.singleton(ScopeProvider.DEFAULT_SCOPE)));
        }
        return this.fields;
    }

    @Override
    public Map<String, ObjectGraph> getSubgraphs() {
        if (this.subgraphs == null) {
            Map<String, Class<?>> contextSubgraphs = this.graph.getSubgraphs(this.filteringScopes);
            contextSubgraphs.putAll(this.graph.getSubgraphs(ScopeProvider.DEFAULT_SCOPE));
            this.subgraphs = Maps.transformValues(contextSubgraphs, new Function<Class<?>, ObjectGraph>(){

                @Override
                public ObjectGraphImpl apply(Class<?> clazz) {
                    return new ObjectGraphImpl(ObjectGraphImpl.this.classToGraph, (EntityGraph)ObjectGraphImpl.this.classToGraph.get(clazz), ObjectGraphImpl.this.filteringScopes);
                }
            });
        }
        return this.subgraphs;
    }
}

