/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.util.Closure;
import org.glassfish.jersey.internal.util.Producer;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.glassfish.jersey.server.ChunkedOutput;
import org.glassfish.jersey.server.CloseableService;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.TracingConfig;
import org.glassfish.jersey.server.TracingUtils;
import org.glassfish.jersey.server.internal.BackgroundScheduler;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.monitoring.RequestEventImpl;
import org.glassfish.jersey.server.internal.process.AsyncContext;
import org.glassfish.jersey.server.internal.process.Endpoint;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.UriRoutingContext;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.glassfish.jersey.spi.ExceptionMappers;

class ServerRuntime {
    private final Stage<ContainerRequest> requestProcessingRoot;
    private final ServiceLocator locator;
    private final ScheduledExecutorService backgroundScheduler;
    private final RequestScope requestScope;
    private final ExceptionMappers exceptionMappers;
    private final Provider<RespondingContext> respondingContextProvider;
    private final Provider<CloseableService> closeableServiceProvider;
    private final Provider<Ref<Value<AsyncContext>>> asyncContextFactoryProvider;
    private final Provider<AsyncContext> asyncContextProvider;
    private final Provider<UriRoutingContext> uriRoutingContextProvider;
    private final ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
    private final ApplicationEventListener applicationEventListener;
    private final Configuration configuration;
    private final TracingConfig tracingConfig;
    private final TracingLogger.Level tracingThreshold;

    private ServerRuntime(Stage<ContainerRequest> requestProcessingRoot, ServiceLocator locator, ScheduledExecutorService backgroundScheduler, RequestScope requestScope, ExceptionMappers exceptionMappers, Provider<RespondingContext> respondingContextProvider, Provider<CloseableService> closeableServiceProvider, Provider<Ref<Value<AsyncContext>>> asyncContextFactoryProvider, Provider<AsyncContext> asyncContextProvider, Provider<UriRoutingContext> uriRoutingContextProvider, ExecutorsFactory<ContainerRequest> asyncExecutorsFactory, ApplicationEventListener applicationEventListener, Configuration configuration) {
        this.requestProcessingRoot = requestProcessingRoot;
        this.locator = locator;
        this.backgroundScheduler = backgroundScheduler;
        this.requestScope = requestScope;
        this.exceptionMappers = exceptionMappers;
        this.respondingContextProvider = respondingContextProvider;
        this.closeableServiceProvider = closeableServiceProvider;
        this.asyncContextFactoryProvider = asyncContextFactoryProvider;
        this.asyncContextProvider = asyncContextProvider;
        this.uriRoutingContextProvider = uriRoutingContextProvider;
        this.asyncExecutorsFactory = asyncExecutorsFactory;
        this.applicationEventListener = applicationEventListener;
        this.configuration = configuration;
        this.tracingConfig = TracingUtils.getTracingConfig(configuration);
        this.tracingThreshold = TracingUtils.getTracingThreshold(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(final ContainerRequest request) {
        this.initRequestEventListeners(request);
        TracingUtils.initTracingSupport(this.tracingConfig, this.tracingThreshold, request);
        try {
            request.checkState();
            this.requestScope.runInScope(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TracingUtils.logStart(request);
                    Responder responder = new Responder(request, ServerRuntime.this);
                    AsyncResponderHolder asyncResponderHolder = new AsyncResponderHolder(responder, ServerRuntime.this.requestScope.referenceCurrent());
                    try {
                        Ref endpointRef = Refs.emptyRef();
                        ContainerRequest data = Stages.process(request, ServerRuntime.this.requestProcessingRoot, endpointRef);
                        Endpoint endpoint = (Endpoint)endpointRef.get();
                        if (endpoint == null) {
                            throw new NotFoundException();
                        }
                        ((Ref)ServerRuntime.this.asyncContextFactoryProvider.get()).set(asyncResponderHolder);
                        ContainerResponse response = (ContainerResponse)endpoint.apply(data);
                        if (!asyncResponderHolder.isAsync()) {
                            responder.process(response);
                        }
                    }
                    catch (Throwable throwable) {
                        responder.process(throwable);
                    }
                    finally {
                        asyncResponderHolder.release();
                    }
                }
            });
        }
        finally {
            request.triggerEvent(RequestEvent.Type.FINISHED);
        }
    }

    private void initRequestEventListeners(ContainerRequest request) {
        RequestEventImpl.Builder requestEventBuilder;
        RequestEventListener requestEventEventListener;
        if (this.applicationEventListener != null && (requestEventEventListener = this.applicationEventListener.onRequest((requestEventBuilder = new RequestEventImpl.Builder().setContainerRequest(request)).build(RequestEvent.Type.START))) != null) {
            request.setRequestEventListener(requestEventEventListener, requestEventBuilder);
        }
    }

    ScheduledExecutorService getBackgroundScheduler() {
        return this.backgroundScheduler;
    }

    static class ConnectionCallbackRunner
    extends AbstractCallbackRunner<ConnectionCallback>
    implements ConnectionCallback {
        private ConnectionCallbackRunner() {
            super(Logger.getLogger(ConnectionCallbackRunner.class.getName()));
        }

        @Override
        public Class<?> getCallbackContract() {
            return ConnectionCallback.class;
        }

        @Override
        public void onDisconnect(final AsyncResponse disconnected) {
            this.executeCallbacks(new Closure<ConnectionCallback>(){

                @Override
                public void invoke(ConnectionCallback callback) {
                    callback.onDisconnect(disconnected);
                }
            });
        }
    }

    private static class CompletionCallbackRunner
    extends AbstractCallbackRunner<CompletionCallback>
    implements CompletionCallback {
        private CompletionCallbackRunner() {
            super(Logger.getLogger(CompletionCallbackRunner.class.getName()));
        }

        @Override
        public Class<?> getCallbackContract() {
            return CompletionCallback.class;
        }

        @Override
        public void onComplete(final Throwable throwable) {
            this.executeCallbacks(new Closure<CompletionCallback>(){

                @Override
                public void invoke(CompletionCallback callback) {
                    callback.onComplete(throwable);
                }
            });
        }
    }

    private static abstract class AbstractCallbackRunner<T> {
        private final Queue<T> callbacks = new ConcurrentLinkedQueue<T>();
        private final Logger logger;

        protected AbstractCallbackRunner(Logger logger2) {
            this.logger = logger2;
        }

        public final boolean supports(Class<?> callbackClass) {
            return this.getCallbackContract().isAssignableFrom(callbackClass);
        }

        public abstract Class<?> getCallbackContract();

        public boolean register(Object callback) {
            return this.callbacks.offer(callback);
        }

        protected final void executeCallbacks(Closure<T> invoker) {
            for (Object callback : this.callbacks) {
                try {
                    invoker.invoke(callback);
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, LocalizationMessages.ERROR_ASYNC_CALLBACK_FAILED(callback.getClass().getName()), t);
                }
            }
        }
    }

    private static class AsyncResponder
    implements AsyncContext,
    ContainerResponseWriter.TimeoutHandler,
    CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(AsyncResponder.class.getName());
        private static final TimeoutHandler DEFAULT_TIMEOUT_HANDLER = new TimeoutHandler(){

            @Override
            public void handleTimeout(AsyncResponse asyncResponse) {
                throw new ServiceUnavailableException();
            }
        };
        private final Object stateLock = new Object();
        private AsyncContext.State state = AsyncContext.State.RUNNING;
        private boolean cancelled = false;
        private final Responder responder;
        private final RequestScope.Instance scopeInstance;
        private volatile TimeoutHandler timeoutHandler = DEFAULT_TIMEOUT_HANDLER;
        private final List<AbstractCallbackRunner<?>> callbackRunners;

        public AsyncResponder(Responder responder, RequestScope.Instance scopeInstance) {
            this.responder = responder;
            this.scopeInstance = scopeInstance;
            this.callbackRunners = Collections.unmodifiableList(Arrays.asList(responder.completionCallbackRunner, responder.connectionCallbackRunner));
            responder.completionCallbackRunner.register(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTimeout(ContainerResponseWriter responseWriter) {
            TimeoutHandler handler = this.timeoutHandler;
            try {
                Object object = this.stateLock;
                synchronized (object) {
                    if (this.state == AsyncContext.State.SUSPENDED) {
                        handler.handleTimeout(this);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.resume(throwable);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(Throwable throwable) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public void invokeManaged(final Producer<Response> producer) {
            this.responder.runtime.asyncExecutorsFactory.getRequestingExecutor(this.responder.request).submit(new Runnable(){

                @Override
                public void run() {
                    AsyncResponder.this.responder.runtime.requestScope.runInScope(AsyncResponder.this.scopeInstance, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Response response = (Response)producer.call();
                                if (response != null) {
                                    AsyncResponder.this.resume(response);
                                }
                            }
                            catch (Throwable t) {
                                AsyncResponder.this.resume(t);
                            }
                        }
                    });
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend() {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == AsyncContext.State.RUNNING) {
                    this.state = AsyncContext.State.SUSPENDED;
                    this.responder.request.getResponseWriter().suspend(0L, TimeUnit.SECONDS, this);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean resume(final Object response) throws IllegalStateException {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    try {
                        Response jaxrsResponse = AsyncResponder.this.toJaxrsResponse(response);
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.request, jaxrsResponse));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
        }

        private Response toJaxrsResponse(Object response) {
            if (response instanceof Response) {
                return (Response)response;
            }
            return Response.ok(response).build();
        }

        @Override
        public boolean resume(final Throwable error) throws IllegalStateException {
            return this.resume(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncResponder.this.responder.process(new MappableException(error));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean resume(Runnable handler) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
            }
            this.responder.runtime.requestScope.runInScope(this.scopeInstance, handler);
            return true;
        }

        @Override
        public boolean cancel() {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).build();
                }
            });
        }

        @Override
        public boolean cancel(final int retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        @Override
        public boolean cancel(final Date retryAfter) {
            return this.cancel(new Value<Response>(){

                @Override
                public Response get() {
                    return Response.status(Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", retryAfter).build();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancel(final Value<Response> responseValue) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelled) {
                    return true;
                }
                if (this.state != AsyncContext.State.SUSPENDED) {
                    return false;
                }
                this.state = AsyncContext.State.RESUMED;
                this.cancelled = true;
            }
            this.responder.runtime.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    try {
                        Response response = (Response)responseValue.get();
                        AsyncResponder.this.responder.process(new ContainerResponse(AsyncResponder.this.responder.request, response));
                    }
                    catch (Throwable t) {
                        AsyncResponder.this.responder.process(t);
                    }
                }
            });
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.RUNNING;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSuspended() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.SUSPENDED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.cancelled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            Object object = this.stateLock;
            synchronized (object) {
                return this.state == AsyncContext.State.COMPLETED;
            }
        }

        @Override
        public boolean setTimeout(long time, TimeUnit unit) {
            try {
                this.responder.request.getResponseWriter().setSuspendTimeout(time, unit);
                return true;
            }
            catch (IllegalStateException ex) {
                LOGGER.log(Level.FINER, "Unable to set timeout on the AsyncResponse.", ex);
                return false;
            }
        }

        @Override
        public void setTimeoutHandler(TimeoutHandler handler) {
            this.timeoutHandler = handler;
        }

        @Override
        public Collection<Class<?>> register(Class<?> callback) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            return this.register(Injections.getOrCreate(this.responder.runtime.locator, callback));
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            Preconditions.checkNotNull(callbacks, LocalizationMessages.CALLBACK_ARRAY_NULL());
            for (Class<?> additionalCallback : callbacks) {
                Preconditions.checkNotNull(additionalCallback, LocalizationMessages.CALLBACK_ARRAY_ELEMENT_NULL());
            }
            HashMap results = new HashMap();
            results.put(callback, this.register(callback));
            for (Class<?> c : callbacks) {
                results.put(c, this.register(c));
            }
            return results;
        }

        @Override
        public Collection<Class<?>> register(Object callback) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            LinkedList result = new LinkedList();
            for (AbstractCallbackRunner<?> runner : this.callbackRunners) {
                if (!runner.supports(callback.getClass()) || !runner.register(callback)) continue;
                result.add(runner.getCallbackContract());
            }
            return result;
        }

        @Override
        public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
            Preconditions.checkNotNull(callback, LocalizationMessages.PARAM_NULL("callback"));
            Preconditions.checkNotNull(callbacks, LocalizationMessages.CALLBACK_ARRAY_NULL());
            for (Object additionalCallback : callbacks) {
                Preconditions.checkNotNull(additionalCallback, LocalizationMessages.CALLBACK_ARRAY_ELEMENT_NULL());
            }
            HashMap results = new HashMap();
            results.put(callback.getClass(), this.register(callback));
            for (Object c : callbacks) {
                results.put(c.getClass(), this.register(c));
            }
            return results;
        }
    }

    private static class Responder {
        private static final Logger LOGGER = Logger.getLogger(Responder.class.getName());
        private final ContainerRequest request;
        private final ServerRuntime runtime;
        private final CompletionCallbackRunner completionCallbackRunner = new CompletionCallbackRunner();
        private final ConnectionCallbackRunner connectionCallbackRunner = new ConnectionCallbackRunner();
        private final TracingLogger tracingLogger;

        public Responder(ContainerRequest request, ServerRuntime runtime) {
            this.request = request;
            this.runtime = runtime;
            this.tracingLogger = TracingLogger.getInstance(request);
        }

        public void process(ContainerResponse response) {
            this.request.getRequestEventBuilder().setContainerResponse(response);
            response = this.processResponse(response);
            this.release(response);
        }

        private ContainerResponse processResponse(ContainerResponse response) {
            Stage<ContainerResponse> respondingRoot = ((RespondingContext)this.runtime.respondingContextProvider.get()).createRespondingRoot();
            if (respondingRoot != null) {
                response = Stages.process(response, respondingRoot);
            }
            this.writeResponse(response);
            this.completionCallbackRunner.onComplete(null);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Throwable throwable) {
            this.request.getRequestEventBuilder().setException(throwable, RequestEvent.ExceptionCause.ORIGINAL);
            this.request.triggerEvent(RequestEvent.Type.ON_EXCEPTION);
            ContainerResponse response = null;
            try {
                Response exceptionResponse = this.mapException(throwable);
                try {
                    try {
                        response = this.convertResponse(exceptionResponse);
                        this.request.getRequestEventBuilder().setContainerResponse(response).setResponseSuccessfullyMapped(true);
                    }
                    finally {
                        this.request.triggerEvent(RequestEvent.Type.EXCEPTION_MAPPING_FINISHED);
                    }
                    this.processResponse(response);
                }
                catch (Throwable respError) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_RESPONSE_FROM_ALREADY_MAPPED_EXCEPTION());
                    this.request.getRequestEventBuilder().setException(respError, RequestEvent.ExceptionCause.MAPPED_RESPONSE);
                    this.request.triggerEvent(RequestEvent.Type.ON_EXCEPTION);
                    throw respError;
                }
                this.release(response);
            }
            catch (Throwable responseError) {
                try {
                    if (!(throwable == responseError || throwable instanceof MappableException && throwable.getCause() == responseError)) {
                        LOGGER.log(Level.FINE, LocalizationMessages.ERROR_EXCEPTION_MAPPING_ORIGINAL_EXCEPTION(), throwable);
                    }
                    LOGGER.log(Level.FINE, LocalizationMessages.ERROR_EXCEPTION_MAPPING_THROWN_TO_CONTAINER(), responseError);
                    try {
                        this.request.getResponseWriter().failure(responseError);
                    }
                    finally {
                        this.completionCallbackRunner.onComplete(responseError);
                    }
                    this.release(response);
                }
                catch (Throwable throwable2) {
                    this.release(response);
                    throw throwable2;
                }
            }
        }

        private ContainerResponse convertResponse(Response exceptionResponse) {
            ContainerResponse containerResponse = new ContainerResponse(this.request, exceptionResponse);
            containerResponse.setMappedFromException(true);
            return containerResponse;
        }

        private Response mapException(Throwable originalThrowable) throws Throwable {
            Throwable throwable = originalThrowable;
            boolean inMappable = false;
            boolean mappingNotFound = false;
            do {
                if (throwable instanceof MappableException) {
                    inMappable = true;
                } else if (inMappable || throwable instanceof WebApplicationException) {
                    Response waeResponse = null;
                    Throwable cause = throwable;
                    if (throwable instanceof WebApplicationException) {
                        WebApplicationException webApplicationException = (WebApplicationException)throwable;
                        cause = webApplicationException.getCause();
                        waeResponse = webApplicationException.getResponse();
                        if (waeResponse.hasEntity()) {
                            return waeResponse;
                        }
                    }
                    if (cause != null) {
                        LOGGER.log(Level.WARNING, LocalizationMessages.WEB_APPLICATION_EXCEPTION_CAUSE(), cause);
                    }
                    long timestamp = this.tracingLogger.timestamp(ServerTraceEvent.EXCEPTION_MAPPING);
                    ExceptionMapper<Throwable> mapper = this.runtime.exceptionMappers.findMapping(throwable);
                    if (mapper != null) {
                        this.request.getRequestEventBuilder().setExceptionMapper(mapper);
                        this.request.triggerEvent(RequestEvent.Type.EXCEPTION_MAPPER_FOUND);
                        try {
                            Response mappedResponse = mapper.toResponse(throwable);
                            if (this.tracingLogger.isLogEnabled(ServerTraceEvent.EXCEPTION_MAPPING)) {
                                this.tracingLogger.logDuration(ServerTraceEvent.EXCEPTION_MAPPING, timestamp, mapper, throwable, throwable.getLocalizedMessage(), mappedResponse != null ? mappedResponse.getStatusInfo() : "-no-response-");
                            }
                            if (mappedResponse != null) {
                                return mappedResponse;
                            }
                            return Response.noContent().build();
                        }
                        catch (Throwable mapperThrowable) {
                            LOGGER.log(Level.SEVERE, LocalizationMessages.EXCEPTION_MAPPER_THROWS_EXCEPTION(mapper.getClass()), mapperThrowable);
                            LOGGER.log(Level.SEVERE, LocalizationMessages.EXCEPTION_MAPPER_FAILED_FOR_EXCEPTION(), throwable);
                            return Response.serverError().build();
                        }
                    }
                    if (waeResponse != null) {
                        return waeResponse;
                    }
                    mappingNotFound = true;
                }
                if (throwable instanceof HeaderValueException && ((HeaderValueException)throwable).getContext() == HeaderValueException.Context.INBOUND) {
                    return Response.status(Response.Status.BAD_REQUEST).build();
                }
                if (inMappable && !mappingNotFound) continue;
                throw throwable;
            } while ((throwable = throwable.getCause()) != null);
            throw originalThrowable;
        }

        private void absolutizeLocationHeaderUri(ContainerResponse response) {
            if (response == null || response.getRequestContext() == null || response.getRequestContext().getBaseUri() == null) {
                return;
            }
            URI responseLocation = response.getLocation();
            if (responseLocation != null && !responseLocation.isAbsolute()) {
                URI baseUri = response.getRequestContext().getBaseUri();
                URI absoluteUri = baseUri.resolve(responseLocation);
                MultivaluedMap<String, Object> headers = response.getWrappedMessageContext().getHeaders();
                List locations = (List)headers.get("Location");
                locations.set(0, absoluteUri);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ContainerResponse writeResponse(final ContainerResponse response) {
            block35: {
                final ContainerResponseWriter writer = this.request.getResponseWriter();
                if (!response.hasEntity()) {
                    this.absolutizeLocationHeaderUri(response);
                    this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
                    this.tracingLogger.flush(response.getHeaders());
                    writer.writeResponseStatusAndHeaders(0L, response);
                    this.setWrittenResponse(response);
                    return response;
                }
                Object entity = response.getEntity();
                boolean skipFinally = false;
                final boolean isHead = this.request.getMethod().equals("HEAD");
                try {
                    response.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                        @Override
                        public OutputStream getOutputStream(int contentLength) throws IOException {
                            Responder.this.absolutizeLocationHeaderUri(response);
                            OutputStream outputStream = writer.writeResponseStatusAndHeaders(contentLength, response);
                            return isHead ? null : outputStream;
                        }
                    });
                    if ((writer.enableResponseBuffering() || isHead) && !response.isChunked()) {
                        response.enableBuffering(this.runtime.configuration);
                    }
                    try {
                        response.setEntityStream(this.request.getWorkers().writeTo(entity, entity.getClass(), response.getEntityType(), response.getEntityAnnotations(), response.getMediaType(), response.getHeaders(), this.request.getPropertiesDelegate(), response.getEntityStream(), ((UriRoutingContext)this.runtime.uriRoutingContextProvider.get()).getBoundWriterInterceptors()));
                    }
                    catch (MappableException mpe) {
                        try {
                            if (mpe.getCause() instanceof IOException) {
                                this.connectionCallbackRunner.onDisconnect((AsyncResponse)this.runtime.asyncContextProvider.get());
                            }
                            throw mpe;
                        }
                        catch (Throwable throwable) {
                            this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
                            this.tracingLogger.flush(response.getHeaders());
                            throw throwable;
                        }
                    }
                    this.tracingLogger.log(ServerTraceEvent.FINISHED, response.getStatusInfo());
                    this.tracingLogger.flush(response.getHeaders());
                    this.setWrittenResponse(response);
                }
                catch (Throwable ex) {
                    if (response.isCommitted()) {
                        LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY(), ex);
                        break block35;
                    }
                    skipFinally = true;
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new MappableException(ex);
                }
                finally {
                    if (!skipFinally) {
                        if (response.isChunked()) {
                            try {
                                response.commitStream();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_COMMITTING_OUTPUT_STREAM(), e);
                            }
                            try {
                                ((ChunkedOutput)entity).setContext(this.runtime.requestScope, this.runtime.requestScope.referenceCurrent(), this.request, response, this.connectionCallbackRunner, this.runtime.asyncContextProvider, (UriRoutingContext)this.runtime.uriRoutingContextProvider.get());
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_WRITING_RESPONSE_ENTITY_CHUNK(), ex);
                            }
                            writer.suspend(0L, TimeUnit.SECONDS, null);
                        } else {
                            try {
                                response.close();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_CLOSING_COMMIT_OUTPUT_STREAM(), e);
                            }
                        }
                    }
                }
            }
            return response;
        }

        private void setWrittenResponse(ContainerResponse response) {
            this.request.getRequestEventBuilder().setContainerResponse(response);
            this.request.getRequestEventBuilder().setSuccess(response.getStatus() < 400);
            this.request.getRequestEventBuilder().setResponseWritten(true);
        }

        private void release(ContainerResponse responseContext) {
            try {
                ((CloseableService)this.runtime.closeableServiceProvider.get()).close();
                if (responseContext != null && !responseContext.isChunked()) {
                    responseContext.close();
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Attempt to release single request processing resources has failed.", throwable);
            }
        }
    }

    private static class AsyncResponderHolder
    implements Value<AsyncContext> {
        private final Responder responder;
        private final RequestScope.Instance scopeInstance;
        private volatile AsyncResponder asyncResponder;

        private AsyncResponderHolder(Responder responder, RequestScope.Instance scopeInstance) {
            this.responder = responder;
            this.scopeInstance = scopeInstance;
        }

        @Override
        public AsyncResponder get() {
            AsyncResponder ar;
            this.asyncResponder = ar = new AsyncResponder(this.responder, this.scopeInstance);
            return ar;
        }

        public boolean isAsync() {
            AsyncResponder ar = this.asyncResponder;
            return ar != null && !ar.isRunning();
        }

        public void release() {
            if (this.asyncResponder == null) {
                this.scopeInstance.release();
            }
        }
    }

    public static class Builder {
        @Inject
        private ServiceLocator locator;
        @Inject
        @BackgroundScheduler
        private ScheduledExecutorService backgroundScheduler;
        @Inject
        private RequestScope requestScope;
        @Inject
        private ExceptionMappers exceptionMappers;
        @Inject
        private Provider<RespondingContext> respondingContextProvider;
        @Inject
        private Provider<CloseableService> closeableServiceProvider;
        @Inject
        private Provider<Ref<Value<AsyncContext>>> asyncContextRefProvider;
        @Inject
        private Provider<AsyncContext> asyncContextProvider;
        @Inject
        private Provider<UriRoutingContext> uriRoutingContextProvider;
        @Inject
        private ExecutorsFactory<ContainerRequest> asyncExecutorsFactory;
        @Inject
        private Configuration configuration;

        public ServerRuntime build(Stage<ContainerRequest> requestProcessingRoot, ApplicationEventListener eventListener) {
            return new ServerRuntime(requestProcessingRoot, this.locator, this.backgroundScheduler, this.requestScope, this.exceptionMappers, this.respondingContextProvider, this.closeableServiceProvider, this.asyncContextRefProvider, this.asyncContextProvider, this.uriRoutingContextProvider, this.asyncExecutorsFactory, eventListener, this.configuration);
        }
    }
}

