/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.transform.Source;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.DataStructures;
import org.glassfish.jersey.internal.util.collection.KeyComparator;
import org.glassfish.jersey.internal.util.collection.KeyComparatorHashMap;
import org.glassfish.jersey.internal.util.collection.KeyComparatorLinkedHashMap;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.MsgTraceEvent;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.message.internal.WriterInterceptorExecutor;
import org.jvnet.hk2.annotations.Optional;

public class MessageBodyFactory
implements MessageBodyWorkers {
    private static final Logger LOGGER = Logger.getLogger(MessageBodyFactory.class.getName());
    public static final KeyComparator<MediaType> MEDIA_TYPE_COMPARATOR = new KeyComparator<MediaType>(){
        private static final long serialVersionUID = 2727819828630827763L;

        @Override
        public boolean equals(MediaType x, MediaType y) {
            return x.getType().equalsIgnoreCase(y.getType()) && x.getSubtype().equalsIgnoreCase(y.getSubtype());
        }

        @Override
        public int hash(MediaType k) {
            return k.getType().toLowerCase().hashCode() + k.getSubtype().toLowerCase().hashCode();
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (this.equals(o1, o2)) {
                return 0;
            }
            if (o1.isWildcardType() ^ o2.isWildcardType()) {
                return o1.isWildcardType() ? 1 : -1;
            }
            if (o1.isWildcardSubtype() ^ o2.isWildcardSubtype()) {
                return o1.isWildcardSubtype() ? 1 : -1;
            }
            return 0;
        }
    };
    private static final Comparator<WorkerModel<?>> WORKER_BY_TYPE_COMPARATOR = new Comparator<WorkerModel<?>>(){

        @Override
        public int compare(WorkerModel<?> o1, WorkerModel<?> o2) {
            Class<?> o1ProviderClassParam = o1.providerClassParam;
            Class<?> o2ProviderClassParam = o2.providerClassParam;
            if (o1ProviderClassParam == o2ProviderClassParam) {
                return this.compare(o2.types, o1.types);
            }
            if (o1ProviderClassParam.isAssignableFrom(o2ProviderClassParam)) {
                return 1;
            }
            if (o2ProviderClassParam.isAssignableFrom(o1ProviderClassParam)) {
                return -1;
            }
            return 0;
        }

        @Override
        private int compare(List<MediaType> mediaTypeList1, List<MediaType> mediaTypeList2) {
            mediaTypeList1 = mediaTypeList1.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList1;
            mediaTypeList2 = mediaTypeList2.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList2;
            return MediaTypes.MEDIA_TYPE_LIST_COMPARATOR.compare(mediaTypeList2, mediaTypeList1);
        }
    };
    private final Boolean legacyProviderOrdering;
    private final List<MbrModel> readers;
    private final List<MbwModel> writers;
    private final Map<MediaType, List<MessageBodyReader>> readersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
    private final Map<MediaType, List<MessageBodyWriter>> writersCache = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
    private final Map<Class<?>, List<MessageBodyReader>> mbrTypeLookupCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);
    private final Map<Class<?>, List<MessageBodyWriter>> mbwTypeLookupCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);
    private final Map<Class<?>, List<MediaType>> typeToMediaTypeReadersCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);
    private final Map<Class<?>, List<MediaType>> typeToMediaTypeWritersCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);
    private final Map<ModelLookupKey, List<MbrModel>> mbrLookupCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);
    private final Map<ModelLookupKey, List<MbwModel>> mbwLookupCache = DataStructures.createConcurrentMap(32, 0.75f, DataStructures.DEFAULT_CONCURENCY_LEVEL);

    @Inject
    public MessageBodyFactory(ServiceLocator locator, @Optional Configuration configuration) {
        this.legacyProviderOrdering = configuration != null && PropertiesHelper.isProperty(configuration.getProperty("jersey.config.workers.legacyOrdering"));
        this.readers = new ArrayList<MbrModel>();
        Set<MessageBodyReader> customMbrs = Providers.getCustomProviders(locator, MessageBodyReader.class);
        Set<MessageBodyReader> mbrs = Providers.getProviders(locator, MessageBodyReader.class);
        MessageBodyFactory.addReaders(this.readers, customMbrs, true);
        mbrs.removeAll(customMbrs);
        MessageBodyFactory.addReaders(this.readers, mbrs, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.readers, new LegacyWorkerComparator(MessageBodyReader.class));
            for (MbrModel model : this.readers) {
                for (MediaType mediaType : model.types) {
                    List<MessageBodyReader> readerList = this.readersCache.get(mediaType);
                    if (readerList == null) {
                        readerList = new ArrayList<MessageBodyReader>();
                        this.readersCache.put(mediaType, readerList);
                    }
                    readerList.add((MessageBodyReader)model.provider);
                }
            }
        }
        this.writers = new ArrayList<MbwModel>();
        Set<MessageBodyWriter> customMbws = Providers.getCustomProviders(locator, MessageBodyWriter.class);
        Set<MessageBodyWriter> mbws = Providers.getProviders(locator, MessageBodyWriter.class);
        MessageBodyFactory.addWriters(this.writers, customMbws, true);
        mbws.removeAll(customMbws);
        MessageBodyFactory.addWriters(this.writers, mbws, false);
        if (this.legacyProviderOrdering.booleanValue()) {
            Collections.sort(this.writers, new LegacyWorkerComparator(MessageBodyWriter.class));
            for (WorkerModel workerModel : this.writers) {
                for (MediaType mt : workerModel.types) {
                    List<MessageBodyWriter> writerList = this.writersCache.get(mt);
                    if (writerList == null) {
                        writerList = new ArrayList<MessageBodyWriter>();
                        this.writersCache.put(mt, writerList);
                    }
                    writerList.add((MessageBodyWriter)workerModel.provider);
                }
            }
        }
    }

    private static void addReaders(List<MbrModel> models, Set<MessageBodyReader> readers, boolean custom) {
        for (MessageBodyReader provider : readers) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Consumes.class));
            models.add(new MbrModel(provider, values, custom));
        }
    }

    private static void addWriters(List<MbwModel> models, Set<MessageBodyWriter> writers, boolean custom) {
        for (MessageBodyWriter provider : writers) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Produces.class));
            models.add(new MbwModel(provider, values, custom));
        }
    }

    @Override
    public Map<MediaType, List<MessageBodyReader>> getReaders(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.readers, subSet);
        return subSet;
    }

    @Override
    public Map<MediaType, List<MessageBodyWriter>> getWriters(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.getCompatibleProvidersMap(mediaType, this.writers, subSet);
        return subSet;
    }

    @Override
    public String readersToString(Map<MediaType, List<MessageBodyReader>> readers) {
        return this.toString(readers);
    }

    @Override
    public String writersToString(Map<MediaType, List<MessageBodyWriter>> writers) {
        return this.toString(writers);
    }

    private <T> String toString(Map<MediaType, List<T>> set) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Map.Entry<MediaType, List<T>> e : set.entrySet()) {
            pw.append(e.getKey().toString()).println(" ->");
            for (T t : e.getValue()) {
                pw.append("  ").println(t.getClass().getName());
            }
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        return this.getMessageBodyReader(c, t, as, mediaType, null);
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, PropertiesDelegate propertiesDelegate) {
        MessageBodyReader<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyReader(c, t, as, mediaType, mediaType, propertiesDelegate)) == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType), propertiesDelegate);
            }
            if (p == null) {
                p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE, propertiesDelegate);
            }
        } else {
            p = this._getMessageBodyReader(c, t, as, mediaType, this.readers, propertiesDelegate);
        }
        return p;
    }

    @Override
    public List<MediaType> getMessageBodyReaderMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        LinkedHashSet<MediaType> readableMediaTypes = Sets.newLinkedHashSet();
        for (MbrModel model : this.readers) {
            boolean readableWorker = false;
            for (MediaType mt : model.types) {
                if (model.isReadable(type, genericType, annotations, mt)) {
                    readableMediaTypes.add(mt);
                    readableWorker = true;
                }
                if (readableMediaTypes.contains(MediaType.WILDCARD_TYPE) || !readableWorker || !model.types.contains(MediaType.WILDCARD_TYPE)) continue;
                readableMediaTypes.add(MediaType.WILDCARD_TYPE);
            }
        }
        ArrayList<MediaType> mtl = Lists.newArrayList(readableMediaTypes);
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    private <T> boolean isCompatible(WorkerModel<T> model, Class c, MediaType mediaType) {
        if (model.providerClassParam.equals(Object.class) || model.providerClassParam.isAssignableFrom(c) || c.isAssignableFrom(model.providerClassParam)) {
            for (MediaType mt : model.types) {
                if (mediaType == null) {
                    return true;
                }
                if (!MediaTypes.typeEqual(mediaType, mt) && !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(mediaType), mt) && !MediaTypes.typeEqual(MediaTypes.GENERAL_MEDIA_TYPE, mt)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MbrModel> models, PropertiesDelegate propertiesDelegate) {
        MbrModel model;
        List<MbrModel> readers = this.mbrLookupCache.get(new ModelLookupKey(c, mediaType));
        if (readers == null) {
            readers = new ArrayList<MbrModel>();
            for (MbrModel model2 : models) {
                if (!this.isCompatible(model2, c, mediaType)) continue;
                readers.add(model2);
            }
            Collections.sort(readers, new WorkerComparator(c, mediaType));
            this.mbrLookupCache.put(new ModelLookupKey(c, mediaType), readers);
        }
        if (readers.isEmpty()) {
            return null;
        }
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        MessageBodyReader selected = null;
        Iterator<MbrModel> iterator = readers.iterator();
        while (iterator.hasNext()) {
            model = iterator.next();
            if (model.isReadable(c, t, as, mediaType)) {
                selected = (MessageBodyReader)model.provider;
                tracingLogger.log(MsgTraceEvent.MBR_SELECTED, selected);
                break;
            }
            tracingLogger.log(MsgTraceEvent.MBR_NOT_READABLE, model.provider);
        }
        if (tracingLogger.isLogEnabled(MsgTraceEvent.MBR_SKIPPED)) {
            while (iterator.hasNext()) {
                model = iterator.next();
                tracingLogger.log(MsgTraceEvent.MBR_SKIPPED, model.provider);
            }
        }
        return selected;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup, PropertiesDelegate propertiesDelegate) {
        MessageBodyReader p;
        List<MessageBodyReader> readers = this.readersCache.get(lookup);
        if (readers == null) {
            return null;
        }
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        MessageBodyReader selected = null;
        Iterator<MessageBodyReader> iterator = readers.iterator();
        while (iterator.hasNext()) {
            p = iterator.next();
            if (MbrModel.isReadable(p, c, t, as, mediaType)) {
                selected = p;
                tracingLogger.log(MsgTraceEvent.MBR_SELECTED, selected);
                break;
            }
            tracingLogger.log(MsgTraceEvent.MBR_NOT_READABLE, p);
        }
        if (tracingLogger.isLogEnabled(MsgTraceEvent.MBR_SKIPPED)) {
            while (iterator.hasNext()) {
                p = iterator.next();
                tracingLogger.log(MsgTraceEvent.MBR_SKIPPED, p);
            }
        }
        return selected;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        return this.getMessageBodyWriter(c, t, as, mediaType, null);
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, PropertiesDelegate propertiesDelegate) {
        MessageBodyWriter<T> p = null;
        if (this.legacyProviderOrdering.booleanValue()) {
            if (mediaType != null && (p = this._getMessageBodyWriter(c, t, as, mediaType, mediaType, propertiesDelegate)) == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType), propertiesDelegate);
            }
            if (p == null) {
                p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE, propertiesDelegate);
            }
        } else {
            p = this._getMessageBodyWriter(c, t, as, mediaType, this.writers, propertiesDelegate);
        }
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, List<MbwModel> models, PropertiesDelegate propertiesDelegate) {
        MbwModel model;
        List<MbwModel> writers = this.mbwLookupCache.get(new ModelLookupKey(c, mediaType));
        if (writers == null) {
            writers = new ArrayList<MbwModel>();
            for (MbwModel model2 : models) {
                if (!this.isCompatible(model2, c, mediaType)) continue;
                writers.add(model2);
            }
            Collections.sort(writers, new WorkerComparator(c, mediaType));
            this.mbwLookupCache.put(new ModelLookupKey(c, mediaType), writers);
        }
        if (writers.isEmpty()) {
            return null;
        }
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        MessageBodyWriter selected = null;
        Iterator<MbwModel> iterator = writers.iterator();
        while (iterator.hasNext()) {
            model = iterator.next();
            if (model.isWriteable(c, t, as, mediaType)) {
                selected = (MessageBodyWriter)model.provider;
                tracingLogger.log(MsgTraceEvent.MBW_SELECTED, selected);
                break;
            }
            tracingLogger.log(MsgTraceEvent.MBW_NOT_WRITEABLE, model.provider);
        }
        if (tracingLogger.isLogEnabled(MsgTraceEvent.MBW_SKIPPED)) {
            while (iterator.hasNext()) {
                model = iterator.next();
                tracingLogger.log(MsgTraceEvent.MBW_SKIPPED, model.provider);
            }
        }
        return selected;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup, PropertiesDelegate propertiesDelegate) {
        MessageBodyWriter p;
        List<MessageBodyWriter> writers = this.writersCache.get(lookup);
        if (writers == null) {
            return null;
        }
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        MessageBodyWriter selected = null;
        Iterator<MessageBodyWriter> iterator = writers.iterator();
        while (iterator.hasNext()) {
            p = iterator.next();
            if (MbwModel.isWriteable(p, c, t, as, mediaType)) {
                selected = p;
                tracingLogger.log(MsgTraceEvent.MBW_SELECTED, selected);
                break;
            }
            tracingLogger.log(MsgTraceEvent.MBW_NOT_WRITEABLE, p);
        }
        if (tracingLogger.isLogEnabled(MsgTraceEvent.MBW_SKIPPED)) {
            while (iterator.hasNext()) {
                p = iterator.next();
                tracingLogger.log(MsgTraceEvent.MBW_SKIPPED, p);
            }
        }
        return selected;
    }

    private <T> void getCompatibleProvidersMap(MediaType mediaType, List<? extends WorkerModel<T>> set, Map<MediaType, List<T>> subSet) {
        if (mediaType.isWildcardType()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
        } else if (mediaType.isWildcardSubtype()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        } else {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.getTypeWildCart(mediaType), set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        }
    }

    private <T> void getCompatibleProvidersList(MediaType mediaType, List<? extends WorkerModel<T>> set, Map<MediaType, List<T>> subSet) {
        ArrayList providers = new ArrayList();
        for (WorkerModel<T> model : set) {
            if (!model.types.contains(mediaType)) continue;
            providers.add(model.provider);
        }
        if (!providers.isEmpty()) {
            subSet.put(mediaType, Collections.unmodifiableList(providers));
        }
    }

    @Override
    public List<MediaType> getMessageBodyWriterMediaTypes(Class<?> c, Type t, Annotation[] as) {
        LinkedHashSet<MediaType> writeableMediaTypes = Sets.newLinkedHashSet();
        for (MbwModel model : this.writers) {
            boolean writeableWorker = false;
            for (MediaType mt : model.types) {
                if (model.isWriteable(c, t, as, mt)) {
                    writeableMediaTypes.add(mt);
                    writeableWorker = true;
                }
                if (writeableMediaTypes.contains(MediaType.WILDCARD_TYPE) || !writeableWorker || !model.types.contains(MediaType.WILDCARD_TYPE)) continue;
                writeableMediaTypes.add(MediaType.WILDCARD_TYPE);
            }
        }
        ArrayList<MediaType> mtl = Lists.newArrayList(writeableMediaTypes);
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    @Override
    public List<MessageBodyWriter> getMessageBodyWritersForType(Class<?> clazz) {
        if (!this.mbwTypeLookupCache.containsKey(clazz)) {
            this.processMessageBodyWritersForType(clazz);
        }
        return this.mbwTypeLookupCache.get(clazz);
    }

    private void processMessageBodyWritersForType(Class<?> clazz) {
        ArrayList<WorkerModel> suitableWriters = Lists.newArrayList();
        if (Response.class.isAssignableFrom(clazz)) {
            suitableWriters.addAll(this.writers);
        } else {
            for (WorkerModel workerModel : this.writers) {
                Class<?> wrapped = Primitives.wrap(clazz);
                if (workerModel.providerClassParam != null && !workerModel.providerClassParam.isAssignableFrom(wrapped) && workerModel.providerClassParam != clazz) continue;
                suitableWriters.add(workerModel);
            }
        }
        this.typeToMediaTypeWritersCache.put(clazz, this.getMessageBodyWorkersMediaTypesByType(suitableWriters));
        Collections.sort(suitableWriters, WORKER_BY_TYPE_COMPARATOR);
        ArrayList writers = Lists.newArrayList();
        for (WorkerModel workerPair : suitableWriters) {
            writers.add(workerPair.provider);
        }
        this.mbwTypeLookupCache.put(clazz, writers);
    }

    @Override
    public List<MediaType> getMessageBodyWriterMediaTypesByType(Class<?> type) {
        if (!this.typeToMediaTypeWritersCache.containsKey(type)) {
            this.processMessageBodyWritersForType(type);
        }
        return this.typeToMediaTypeWritersCache.get(type);
    }

    @Override
    public List<MediaType> getMessageBodyReaderMediaTypesByType(Class<?> type) {
        if (!this.typeToMediaTypeReadersCache.containsKey(type)) {
            this.processMessageBodyReadersForType(type);
        }
        return this.typeToMediaTypeReadersCache.get(type);
    }

    private <T> List<MediaType> getMessageBodyWorkersMediaTypesByType(List<? extends WorkerModel<T>> workerModels) {
        HashSet<MediaType> mediaTypeSet = Sets.newHashSet();
        for (WorkerModel<T> model : workerModels) {
            mediaTypeSet.addAll(model.types);
        }
        ArrayList<MediaType> mediaTypes = Lists.newArrayList(mediaTypeSet);
        Collections.sort(mediaTypes, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mediaTypes;
    }

    @Override
    public List<MessageBodyReader> getMessageBodyReadersForType(Class<?> clazz) {
        if (!this.mbrTypeLookupCache.containsKey(clazz)) {
            this.processMessageBodyReadersForType(clazz);
        }
        return this.mbrTypeLookupCache.get(clazz);
    }

    private void processMessageBodyReadersForType(Class<?> clazz) {
        ArrayList<MbrModel> suitableReaders = Lists.newArrayList();
        for (MbrModel reader : this.readers) {
            Class<?> wrapped = Primitives.wrap(clazz);
            if (reader.providerClassParam != null && !reader.providerClassParam.isAssignableFrom(wrapped) && reader.providerClassParam != clazz) continue;
            suitableReaders.add(reader);
        }
        this.typeToMediaTypeReadersCache.put(clazz, this.getMessageBodyWorkersMediaTypesByType(suitableReaders));
        Collections.sort(suitableReaders, WORKER_BY_TYPE_COMPARATOR);
        ArrayList<Object> readers = Lists.newArrayList();
        for (MbrModel reader : suitableReaders) {
            readers.add(reader.provider);
        }
        this.mbrTypeLookupCache.put(clazz, readers);
    }

    @Override
    public MediaType getMessageBodyWriterMediaType(Class<?> c, Type t, Annotation[] as, List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptable : acceptableMediaTypes) {
            for (MbwModel model : this.writers) {
                for (MediaType mt : model.types) {
                    if (!mt.isCompatible(acceptable) || !model.isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readFrom(Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, PropertiesDelegate propertiesDelegate, InputStream entityStream, Iterable<ReaderInterceptor> readerInterceptors, boolean translateNce) throws WebApplicationException, IOException {
        Object object;
        ReaderInterceptorExecutor executor = new ReaderInterceptorExecutor(rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, readerInterceptors, translateNce);
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        long timestamp = tracingLogger.timestamp(MsgTraceEvent.RI_SUMMARY);
        try {
            InputStream stream;
            Object instance = executor.proceed();
            if (!(instance instanceof Closeable) && !(instance instanceof Source) && (stream = executor.getInputStream()) != null) {
                stream.close();
            }
            object = instance;
        }
        catch (Throwable throwable) {
            tracingLogger.logDuration(MsgTraceEvent.RI_SUMMARY, timestamp, executor.getProcessedCount());
            throw throwable;
        }
        tracingLogger.logDuration(MsgTraceEvent.RI_SUMMARY, timestamp, executor.getProcessedCount());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream writeTo(Object t, Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, Iterable<WriterInterceptor> writerInterceptors) throws IOException, WebApplicationException {
        WriterInterceptorExecutor executor = new WriterInterceptorExecutor(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, writerInterceptors);
        TracingLogger tracingLogger = TracingLogger.getInstance(propertiesDelegate);
        long timestamp = tracingLogger.timestamp(MsgTraceEvent.WI_SUMMARY);
        try {
            executor.proceed();
        }
        catch (Throwable throwable) {
            tracingLogger.logDuration(MsgTraceEvent.WI_SUMMARY, timestamp, executor.getProcessedCount());
            throw throwable;
        }
        tracingLogger.logDuration(MsgTraceEvent.WI_SUMMARY, timestamp, executor.getProcessedCount());
        return executor.getOutputStream();
    }

    private static class ModelLookupKey {
        final Class<?> clazz;
        final MediaType mediaType;

        private ModelLookupKey(Class<?> clazz, MediaType mediaType) {
            this.clazz = clazz;
            this.mediaType = mediaType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelLookupKey that = (ModelLookupKey)o;
            return !(this.clazz == null ? that.clazz != null : !this.clazz.equals(that.clazz)) && !(this.mediaType == null ? that.mediaType != null : !this.mediaType.equals(that.mediaType));
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.mediaType != null ? this.mediaType.hashCode() : 0);
            return result;
        }
    }

    private static class LegacyWorkerComparator<T>
    implements Comparator<WorkerModel<T>> {
        final DeclarationDistanceComparator<T> distanceComparator;

        private LegacyWorkerComparator(Class<T> type) {
            this.distanceComparator = new DeclarationDistanceComparator<T>(type);
        }

        @Override
        public int compare(WorkerModel<T> modelA, WorkerModel<T> modelB) {
            if (modelA.custom ^ modelB.custom) {
                return modelA.custom != false ? -1 : 1;
            }
            int mediaTypeComparison = MEDIA_TYPE_COMPARATOR.compare(modelA.types.get(0), modelB.types.get(0));
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            return this.distanceComparator.compare(modelA.provider, modelB.provider);
        }
    }

    private static class WorkerComparator<T>
    implements Comparator<WorkerModel<T>> {
        final Class wantedType;
        final MediaType wantedMediaType;

        private WorkerComparator(Class wantedType, MediaType wantedMediaType) {
            this.wantedType = wantedType;
            this.wantedMediaType = wantedMediaType;
        }

        @Override
        public int compare(WorkerModel<T> modelA, WorkerModel<T> modelB) {
            int distance = this.compareTypeDistances(modelA.providerClassParam, modelB.providerClassParam);
            if (distance != 0) {
                return distance;
            }
            int mediaTypeComparison = this.getMediaTypeDistance(this.wantedMediaType, modelA.types) - this.getMediaTypeDistance(this.wantedMediaType, modelB.types);
            if (mediaTypeComparison != 0) {
                return mediaTypeComparison;
            }
            if (modelA.custom ^ modelB.custom) {
                return modelA.custom != false ? -1 : 1;
            }
            return 0;
        }

        private int getMediaTypeDistance(MediaType wanted, List<MediaType> mtl) {
            if (wanted == null) {
                return 0;
            }
            int distance = 2;
            for (MediaType mt : mtl) {
                if (MediaTypes.typeEqual(wanted, mt)) {
                    return 0;
                }
                if (distance <= 1 || !MediaTypes.typeEqual(MediaTypes.getTypeWildCart(wanted), mt)) continue;
                distance = 1;
            }
            return distance;
        }

        private int compareTypeDistances(Class<?> providerClassParam1, Class<?> providerClassParam2) {
            return this.getTypeDistance(providerClassParam1) - this.getTypeDistance(providerClassParam2);
        }

        private int getTypeDistance(Class<?> classParam) {
            Class tmp1 = this.wantedType;
            Class<?> tmp2 = classParam;
            Iterator<Class<?>> it1 = this.getClassHierarchyIterator(tmp1);
            Iterator<Class<?>> it2 = this.getClassHierarchyIterator(tmp2);
            int distance = 0;
            while (!this.wantedType.equals(tmp2) && !classParam.equals(tmp1)) {
                ++distance;
                if (!this.wantedType.equals(tmp2)) {
                    Class<?> clazz = tmp2 = it2.hasNext() ? it2.next() : null;
                }
                if (!classParam.equals(tmp1)) {
                    Class clazz = tmp1 = it1.hasNext() ? it1.next() : null;
                }
                if (tmp2 != null || tmp1 != null) continue;
                return Integer.MAX_VALUE;
            }
            return distance;
        }

        private Iterator<Class<?>> getClassHierarchyIterator(Class<?> classParam) {
            if (classParam == null) {
                return Collections.emptyList().iterator();
            }
            ArrayList<Class> classes = new ArrayList<Class>();
            LinkedList unprocessed = new LinkedList();
            unprocessed.add(classParam);
            while (!unprocessed.isEmpty()) {
                Class clazz = (Class)unprocessed.removeFirst();
                classes.add(clazz);
                unprocessed.addAll(Arrays.asList(clazz.getInterfaces()));
                Class superclazz = clazz.getSuperclass();
                if (superclazz == null) continue;
                unprocessed.add(superclazz);
            }
            return classes.iterator();
        }
    }

    private static class DeclarationDistanceComparator<T>
    implements Comparator<T> {
        private final Class<T> declared;
        private final Map<Class, Integer> distanceMap = new HashMap<Class, Integer>();

        DeclarationDistanceComparator(Class<T> declared) {
            this.declared = declared;
        }

        @Override
        public int compare(T o1, T o2) {
            int d1 = this.getDistance(o1);
            int d2 = this.getDistance(o2);
            return d2 - d1;
        }

        private int getDistance(T t) {
            Integer distance = this.distanceMap.get(t.getClass());
            if (distance != null) {
                return distance;
            }
            distance = 0;
            for (Class a = (as = ReflectionHelper.getParameterizedClassArguments(p = ReflectionHelper.getClass(t.getClass(), this.declared))) != null ? as[0] : null; a != null && a != Object.class; a = a.getSuperclass()) {
                Integer n = distance;
                Integer n2 = distance = Integer.valueOf(distance + 1);
            }
            this.distanceMap.put(t.getClass(), distance);
            return distance;
        }
    }

    private static class MbwModel
    extends WorkerModel<MessageBodyWriter> {
        public MbwModel(MessageBodyWriter provider, List<MediaType> types, Boolean custom) {
            super(provider, types, custom, MessageBodyWriter.class);
        }

        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return MbwModel.isWriteable((MessageBodyWriter)this.provider, type, genericType, annotations, mediaType);
        }

        public static boolean isWriteable(MessageBodyWriter provider, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            try {
                return provider.isWriteable(type, genericType, annotations, mediaType);
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, LocalizationMessages.ERROR_MBW_ISWRITABLE(provider.getClass().getName()), ex);
                }
                return false;
            }
        }
    }

    private static class MbrModel
    extends WorkerModel<MessageBodyReader> {
        public MbrModel(MessageBodyReader provider, List<MediaType> types, Boolean custom) {
            super(provider, types, custom, MessageBodyReader.class);
        }

        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return MbrModel.isReadable((MessageBodyReader)this.provider, type, genericType, annotations, mediaType);
        }

        public static boolean isReadable(MessageBodyReader provider, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            try {
                return provider.isReadable(type, genericType, annotations, mediaType);
            }
            catch (Exception ex) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, LocalizationMessages.ERROR_MBR_ISREADABLE(provider.getClass().getName()), ex);
                }
                return false;
            }
        }
    }

    private static class WorkerModel<T> {
        public final T provider;
        public final List<MediaType> types;
        public final Boolean custom;
        public final Class<?> providerClassParam;

        protected WorkerModel(T provider, List<MediaType> types, Boolean custom, Class<T> providerType) {
            this.provider = provider;
            this.types = types;
            this.custom = custom;
            this.providerClassParam = WorkerModel.getProviderClassParam(provider, providerType);
        }

        private static Class<?> getProviderClassParam(Object provider, Class<?> providerType) {
            ReflectionHelper.DeclaringClassInterfacePair pair = ReflectionHelper.getClass(provider.getClass(), providerType);
            Class[] classArgs = ReflectionHelper.getParameterizedClassArguments(pair);
            return classArgs != null ? classArgs[0] : Object.class;
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            this.bindAsContract(MessageBodyFactory.class).to(MessageBodyWorkers.class).in(Singleton.class);
        }
    }
}

