/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.status;

import eu.europeana.cloud.common.exceptions.GenericException;
import eu.europeana.cloud.common.exceptions.ProviderDoesNotExistException;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.uis.exception.CloudIdDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.DatabaseConnectionException;
import eu.europeana.cloud.service.uis.exception.IdHasBeenMappedException;
import eu.europeana.cloud.service.uis.exception.ProviderAlreadyExistsException;
import eu.europeana.cloud.service.uis.exception.RecordDatasetEmptyException;
import eu.europeana.cloud.service.uis.exception.RecordDoesNotExistException;
import eu.europeana.cloud.service.uis.exception.RecordExistsException;
import eu.europeana.cloud.service.uis.exception.RecordIdDoesNotExistException;
import javax.ws.rs.core.Response;

public enum IdentifierErrorTemplate {
    GENERIC_ERROR{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("GENERIC_ERROR", String.format("Unspecified Error occured with message %s", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }

        public GenericException getException(ErrorInfo e) {
            return new GenericException(e);
        }
    }
    ,
    DATABASE_CONNECTION_ERROR{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("DATABASE_CONNECTION_ERROR", String.format("The connection to the DB %s/%s failed with error %s", args[0], args[1], args[2]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }

        public DatabaseConnectionException getException(ErrorInfo e) {
            return new DatabaseConnectionException(e);
        }
    }
    ,
    RECORD_EXISTS{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("RECORD_EXISTS", String.format("An identifier for provider id %s and record id %s already exists in the database", args[0], args[1]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public RecordExistsException getException(ErrorInfo e) {
            return new RecordExistsException(e);
        }
    }
    ,
    RECORD_DOES_NOT_EXIST{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("RECORD_DOES_NOT_EXIST", String.format("A global identifier for provider id %s and record id %s does not exist", args[0], args[1]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public RecordDoesNotExistException getException(ErrorInfo e) {
            return new RecordDoesNotExistException(e);
        }
    }
    ,
    CLOUDID_DOES_NOT_EXIST{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("CLOUDID_DOES_NOT_EXIST", String.format("The supplied cloud identifier %s does not exist", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public CloudIdDoesNotExistException getException(ErrorInfo e) {
            return new CloudIdDoesNotExistException(e);
        }
    }
    ,
    PROVIDER_DOES_NOT_EXIST{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("PROVIDER_DOES_NOT_EXIST", String.format("The supplied provider identifier %s does not exist", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public ProviderDoesNotExistException getException(ErrorInfo e) {
            return new ProviderDoesNotExistException(e);
        }
    }
    ,
    PROVIDER_ALREADY_EXISTS{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("PROVIDER_ALREADY_EXISTS", String.format("The provider with identifier %s already exists", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public ProviderAlreadyExistsException getException(ErrorInfo e) {
            return new ProviderAlreadyExistsException(e);
        }
    }
    ,
    RECORDID_DOES_NOT_EXIST{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("RECORDID_DOES_NOT_EXIST", String.format("The supplied record identifier %s does not exist", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public RecordIdDoesNotExistException getException(ErrorInfo e) {
            return new RecordIdDoesNotExistException(e);
        }
    }
    ,
    RECORDSET_EMPTY{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("RECORDSET_EMPTY", String.format("The supplied provider %s does not have any records associated with it", args[0]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.NOT_FOUND;
        }

        public RecordDatasetEmptyException getException(ErrorInfo e) {
            return new RecordDatasetEmptyException(e);
        }
    }
    ,
    ID_HAS_BEEN_MAPPED{

        @Override
        public ErrorInfo getErrorInfo(String ... args) {
            return new ErrorInfo("ID_HAS_BEEN_MAPPED", String.format("The supplied %s id for provider %s has already been assigned to the cloud identifier %s", args[0], args[1], args[2]));
        }

        @Override
        public Response.Status getHttpCode() {
            return Response.Status.CONFLICT;
        }

        public IdHasBeenMappedException getException(ErrorInfo e) {
            return new IdHasBeenMappedException(e);
        }
    };


    public abstract ErrorInfo getErrorInfo(String ... var1);

    public abstract Response.Status getHttpCode();

    public abstract <T extends GenericException> T getException(ErrorInfo var1);
}

