/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.uis.encoder;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public final class Base36 {
    private static final char[] DICTIONARY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'};
    private static final int ASCII_OFFSET = 48;
    private static final int OFFSET = 100;
    private static final int LENGTH = 11;

    private Base36() {
    }

    public static String encode(String str) {
        return Base36.encode(new BigInteger(Base36.convertToNum(str)));
    }

    public static String timeEncode(String str) {
        return Base36.encode(new BigInteger(Base36.convertToNum(new Date().getTime())));
    }

    private static String encode(BigInteger given) {
        ArrayList<Character> result = new ArrayList<Character>();
        BigInteger base = new BigInteger("" + DICTIONARY.length);
        int exponent = 1;
        BigInteger remaining = given;
        while (true) {
            BigInteger power = base.pow(exponent);
            BigInteger modulo = remaining.mod(power);
            BigInteger powerMinusOne = base.pow(exponent - 1);
            BigInteger times = modulo.divide(powerMinusOne);
            result.add(Character.valueOf(DICTIONARY[times.intValue()]));
            remaining = remaining.subtract(modulo);
            if (remaining.equals(BigInteger.ZERO)) break;
            ++exponent;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = result.size() - 1; i > -1; --i) {
            sb.append(result.get(i));
        }
        if (sb.length() < 11) {
            char[] cArr = new char[11 - sb.length()];
            Arrays.fill(cArr, '0');
            sb.append(cArr);
            return sb.reverse().toString();
        }
        return sb.substring(0, 11);
    }

    private static String convertToNum(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            sb.append(c * (int)(Math.random() * 100.0));
        }
        return sb.toString();
    }

    private static String convertToNum(long lng) {
        StringBuilder sb = new StringBuilder();
        for (char c : Long.toString(lng).toCharArray()) {
            sb.append(c * (int)(Math.random() * 100.0));
        }
        return sb.toString();
    }
}

