/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.model.Revision;
import eu.europeana.cloud.common.utils.Tags;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RevisionIsNotValidException;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import jersey.repackaged.com.google.common.collect.Sets;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}/revisions")
@Component
@Scope(value="request")
public class RevisionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RequestsLogger");
    @Autowired
    private RecordService recordService;
    @Autowired
    private DataSetService dataSetService;

    @POST
    @Path(value="/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tag/{TAG}")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    public Response addRevision(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="REVISION_NAME") String revisionName, @PathParam(value="TAG") String tag, @PathParam(value="REVISION_PROVIDER_ID") String revisionProviderId) throws RepresentationNotExistsException, RevisionIsNotValidException, ProviderNotExistsException {
        ParamUtil.validate((String)"TAG", (Object)tag, Arrays.asList(Tags.ACCEPTANCE.getTag(), Tags.PUBLISHED.getTag(), Tags.DELETED.getTag()));
        Revision revision = new Revision(revisionName, revisionProviderId);
        this.setRevisionTags(revision, new HashSet<String>(Arrays.asList(tag)));
        this.addRevision(globalId, schema, version, revision);
        this.recordService.insertRepresentationRevision(globalId, schema, revisionProviderId, revisionName, version, revision.getCreationTimeStamp());
        return Response.created((URI)uriInfo.getAbsolutePath()).build();
    }

    private void addRevision(String globalId, String schema, String version, Revision revision) throws RevisionIsNotValidException, ProviderNotExistsException, RepresentationNotExistsException {
        this.createAssignmentToRevisionOnDataSets(globalId, schema, version, revision);
        this.recordService.addRevision(globalId, schema, version, revision);
        this.dataSetService.updateProviderDatasetRepresentation(globalId, schema, version, revision);
        this.recordService.insertRepresentationRevision(globalId, schema, revision.getRevisionProviderId(), revision.getRevisionName(), version, revision.getCreationTimeStamp());
        this.dataSetService.updateAllRevisionDatasetsEntries(globalId, schema, version, revision);
    }

    private void createAssignmentToRevisionOnDataSets(String globalId, String schema, String version, Revision revision) throws ProviderNotExistsException, RepresentationNotExistsException {
        Map dataSets = this.dataSetService.getDataSets(globalId, schema, version);
        for (Map.Entry entry : dataSets.entrySet()) {
            for (String dataset : (Set)entry.getValue()) {
                this.dataSetService.addDataSetsRevisions((String)entry.getKey(), dataset, revision, schema, globalId);
            }
        }
    }

    @POST
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    @Consumes(value={"application/json"})
    public Response addRevision(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, Revision revision) throws RevisionIsNotValidException, ProviderNotExistsException, RepresentationNotExistsException {
        this.addRevision(globalId, schema, version, revision);
        this.recordService.insertRepresentationRevision(globalId, schema, revision.getRevisionProviderId(), revision.getRevisionName(), version, revision.getCreationTimeStamp());
        return Response.created((URI)uriInfo.getAbsolutePath()).build();
    }

    @POST
    @Path(value="/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}/tags")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    public Response addRevision(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="REVISION_NAME") String revisionName, @PathParam(value="REVISION_PROVIDER_ID") String revisionProviderId, @FormParam(value="tags") Set<String> tags) throws RepresentationNotExistsException, RevisionIsNotValidException, ProviderNotExistsException {
        ParamUtil.validateTags(tags, new HashSet(Sets.newHashSet((Object[])new String[]{Tags.ACCEPTANCE.getTag(), Tags.PUBLISHED.getTag(), Tags.DELETED.getTag()})));
        Revision revision = new Revision(revisionName, revisionProviderId);
        this.setRevisionTags(revision, tags);
        this.addRevision(globalId, schema, version, revision);
        this.recordService.insertRepresentationRevision(globalId, schema, revisionProviderId, revisionName, version, revision.getCreationTimeStamp());
        return Response.created((URI)uriInfo.getAbsolutePath()).entity((Object)revision).build();
    }

    private Revision setRevisionTags(Revision revision, Set<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return revision;
        }
        if (tags.contains(Tags.ACCEPTANCE.getTag())) {
            revision.setAcceptance(true);
        }
        if (tags.contains(Tags.PUBLISHED.getTag())) {
            revision.setPublished(true);
        }
        if (tags.contains(Tags.DELETED.getTag())) {
            revision.setDeleted(true);
        }
        return revision;
    }

    @DELETE
    @Path(value="/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}")
    @PreAuthorize(value="hasPermission(#cloudId.concat('/').concat(#representationName).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    public void deleteRevision(@PathParam(value="CLOUDID") String cloudId, @PathParam(value="REPRESENTATIONNAME") String representationName, @PathParam(value="VERSION") String version, @PathParam(value="REVISION_NAME") String revisionName, @PathParam(value="REVISION_PROVIDER_ID") String revisionProviderId, @QueryParam(value="revisionTimestamp") String revisionTimestamp) throws RepresentationNotExistsException {
        if (revisionTimestamp == null) {
            throw new WebApplicationException("Revision timestamp parameter cannot be null");
        }
        DateTime timestamp = new DateTime((Object)revisionTimestamp, DateTimeZone.UTC);
        this.dataSetService.deleteRevision(cloudId, representationName, version, revisionName, revisionProviderId, timestamp.toDate());
    }
}

