/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.google.common.collect.ImmutableMap;
import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.RepresentationRevisionResponse;
import eu.europeana.cloud.service.mcs.rest.DataSetResource;
import eu.europeana.cloud.service.mcs.rest.FileResource;
import eu.europeana.cloud.service.mcs.rest.RepresentationVersionResource;
import eu.europeana.cloud.service.mcs.rest.RepresentationVersionsResource;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriInfo;

/*
 * Exception performing whole class analysis ignored.
 */
final class EnrichUriUtil {
    static void enrich(UriInfo uriInfo, Record record) {
        for (Representation rep : record.getRepresentations()) {
            EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)rep);
        }
    }

    static void enrich(UriInfo uriInfo, Representation representation) {
        URI allVersionsUri = uriInfo.getBaseUriBuilder().path(RepresentationVersionsResource.class).buildFromMap((Map)ImmutableMap.of((Object)"CLOUDID", (Object)representation.getCloudId(), (Object)"REPRESENTATIONNAME", (Object)representation.getRepresentationName()));
        representation.setAllVersionsUri(uriInfo.resolve(allVersionsUri));
        if (representation.getVersion() != null) {
            URI latestVersionUri = uriInfo.getBaseUriBuilder().path(RepresentationVersionResource.class).buildFromMap((Map)ImmutableMap.of((Object)"CLOUDID", (Object)representation.getCloudId(), (Object)"REPRESENTATIONNAME", (Object)representation.getRepresentationName(), (Object)"VERSION", (Object)representation.getVersion()));
            representation.setUri(uriInfo.resolve(latestVersionUri));
        }
        if (representation.getFiles() != null) {
            for (File f : representation.getFiles()) {
                EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation, (File)f);
            }
        }
    }

    static void enrich(UriInfo uriInfo, RepresentationRevisionResponse representationRevision) {
        if (representationRevision.getFiles() != null) {
            for (File f : representationRevision.getFiles()) {
                EnrichUriUtil.enrich((UriInfo)uriInfo, (String)representationRevision.getCloudId(), (String)representationRevision.getRepresentationName(), (String)representationRevision.getVersion(), (File)f);
            }
        }
    }

    static void enrich(UriInfo uriInfo, Representation rep, File file) {
        EnrichUriUtil.enrich((UriInfo)uriInfo, (String)rep.getCloudId(), (String)rep.getRepresentationName(), (String)rep.getVersion(), (File)file);
    }

    static void enrich(UriInfo uriInfo, String recordId, String schema, String version, File file) {
        URI fileUri = uriInfo.getBaseUriBuilder().path(FileResource.class).buildFromMap((Map)ImmutableMap.of((Object)"CLOUDID", (Object)recordId, (Object)"REPRESENTATIONNAME", (Object)schema, (Object)"VERSION", (Object)version, (Object)"FILENAME", (Object)file.getFileName()));
        file.setContentUri(uriInfo.resolve(fileUri));
    }

    static void enrich(UriInfo uriInfo, DataSet dataSet) {
        URI datasetUri = uriInfo.getBaseUriBuilder().path(DataSetResource.class).buildFromMap((Map)ImmutableMap.of((Object)"DATAPROVIDER", (Object)dataSet.getProviderId(), (Object)"DATASET", (Object)dataSet.getId()));
        dataSet.setUri(uriInfo.resolve(datasetUri));
    }

    private EnrichUriUtil() {
    }
}

