/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest.storage.selector;

import com.google.common.collect.ImmutableSet;
import eu.europeana.cloud.service.mcs.Storage;
import eu.europeana.cloud.service.mcs.rest.storage.selector.ContentStreamDetector;
import eu.europeana.cloud.service.mcs.rest.storage.selector.PreBufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;

public class StorageSelector {
    private static final Set<MediaType> STORE_ONLY_IN_OBJECT_STORAGE = ImmutableSet.of((Object)MediaType.image((String)"jp2"));
    private final PreBufferedInputStream inputStream;
    private final int objectStoreSizeThreshold;
    private final MediaType userMediaType;

    public StorageSelector(PreBufferedInputStream inputStream, String userMediaType) {
        this.inputStream = inputStream;
        this.objectStoreSizeThreshold = inputStream.getBufferSize();
        this.userMediaType = MediaType.parse((String)userMediaType);
    }

    public Storage selectStorage() {
        return this.decide(this.assertUserMediaType(), this.getAvailable());
    }

    protected Storage decide(MediaType detected, int available) {
        if (!STORE_ONLY_IN_OBJECT_STORAGE.contains(detected) && this.objectStoreSizeThreshold > available) {
            return Storage.DATA_BASE;
        }
        return Storage.OBJECT_STORAGE;
    }

    private int getAvailable() {
        int available;
        try {
            available = this.inputStream.available();
        }
        catch (IOException e) {
            throw new BadRequestException("Unable to check data content length!", (Throwable)e);
        }
        return available;
    }

    private MediaType assertUserMediaType() {
        MediaType detected;
        try {
            detected = ContentStreamDetector.detectMediaType((InputStream)this.inputStream);
        }
        catch (IOException e) {
            throw new BadRequestException("Unable to detect mime type.", (Throwable)e);
        }
        if (this.userMediaType == null || !this.userTypeMatchesDetectedType(detected)) {
            throw new BadRequestException("Provided media type does not match to content media type! The content media type is " + detected);
        }
        return detected;
    }

    private boolean userTypeMatchesDetectedType(MediaType calculatedType) {
        if (calculatedType.equals((Object)MediaType.OCTET_STREAM) && calculatedType.equals((Object)this.userMediaType)) {
            return true;
        }
        MediaTypeRegistry registry = MediaTypeRegistry.getDefaultRegistry();
        while (calculatedType != null && !calculatedType.equals((Object)MediaType.OCTET_STREAM)) {
            if (calculatedType.equals((Object)this.userMediaType)) {
                return true;
            }
            for (MediaType alias : registry.getAliases(calculatedType)) {
                if (!alias.equals((Object)this.userMediaType)) continue;
                return true;
            }
            calculatedType = registry.getSupertype(calculatedType);
        }
        return false;
    }
}

