/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Record;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}")
@Component
@Scope(value="request")
public class RepresentationResource {
    @Autowired
    private RecordService recordService;
    @Autowired
    private MutableAclService mutableAclService;
    private final String RECORD_CLASS_NAME = Record.class.getName();
    private final String REPRESENTATION_CLASS_NAME = Representation.class.getName();

    @GET
    @Produces(value={"application/xml", "application/json"})
    @PostAuthorize(value="hasPermission(  (#globalId).concat('/').concat(#schema).concat('/').concat(returnObject.version) , 'eu.europeana.cloud.common.model.Representation', read)")
    @ReturnType(value="eu.europeana.cloud.common.model.Representation")
    public Representation getRepresentation(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema) throws RepresentationNotExistsException {
        Representation info = this.recordService.getRepresentation(globalId, schema);
        this.prepare(uriInfo, info);
        return info;
    }

    @DELETE
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteRepresentation(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema) throws RepresentationNotExistsException {
        this.recordService.deleteRepresentation(globalId, schema);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @PreAuthorize(value="isAuthenticated()")
    public Response createRepresentation(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @FormParam(value="providerId") String providerId) throws RecordNotExistsException, ProviderNotExistsException {
        ParamUtil.require((String)"providerId", (Object)providerId);
        Representation version = this.recordService.createRepresentation(globalId, schema, providerId);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)version);
        String creatorName = SpringUserUtils.getUsername();
        if (creatorName != null) {
            ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + version.getVersion())));
            MutableAcl versionAcl = this.mutableAclService.createAcl((ObjectIdentity)versionIdentity);
            versionAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(creatorName), true);
            versionAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(creatorName), true);
            this.mutableAclService.updateAcl(versionAcl);
        }
        return Response.created((URI)version.getUri()).build();
    }

    private void prepare(UriInfo uriInfo, Representation representation) {
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation);
    }
}

