/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.File;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.selectors.LatestPersistentRepresentationVersionSelector;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.FileNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import eu.europeana.cloud.service.mcs.rest.SimplifiedFileAccessResource;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/records/{LOCALID:.+}/representations/{REPRESENTATIONNAME}/{FILENAME:.+}")
@Scope(value="request")
@Component
public class SimplifiedFileAccessResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifiedFileAccessResource.class);
    @Autowired
    private RecordService recordService;
    @Autowired
    private UISClientHandler uisClientHandler;
    @Autowired
    private PermissionEvaluator permissionEvaluator;

    @GET
    public Response getFile(@Context UriInfo uriInfo, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="LOCALID") String localId, @PathParam(value="REPRESENTATIONNAME") String representationName, @PathParam(value="FILENAME") String fileName) throws RepresentationNotExistsException, FileNotExistsException, CloudException, RecordNotExistsException, ProviderNotExistsException {
        LOGGER.info("Reading file in friendly way for: provider: {}, localId: {}, represenatation: {}, fileName: {}", new Object[]{providerId, localId, representationName, fileName});
        String cloudId = this.findCloudIdFor(providerId, localId);
        Representation representation = this.selectRepresentationVersion(cloudId, representationName);
        if (representation == null) {
            throw new RepresentationNotExistsException();
        }
        if (this.userHasRightsToReadFile(cloudId, representation.getRepresentationName(), representation.getVersion())) {
            File requestedFile = this.readFile(cloudId, representationName, representation.getVersion(), fileName);
            String md5 = requestedFile.getMd5();
            String fileMimeType = null;
            if (StringUtils.isNotBlank((String)requestedFile.getMimeType())) {
                fileMimeType = requestedFile.getMimeType();
            }
            EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation, (File)requestedFile);
            1 output = new /* Unavailable Anonymous Inner Class!! */;
            return Response.status((Response.Status)Response.Status.OK).entity((Object)output).location(requestedFile.getContentUri()).type(fileMimeType).tag(md5).build();
        }
        throw new AccessDeniedException("Access is denied");
    }

    @HEAD
    public Response getFileHeaders(@Context UriInfo uriInfo, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="LOCALID") String localId, @PathParam(value="REPRESENTATIONNAME") String representationName, @PathParam(value="FILENAME") String fileName) throws RepresentationNotExistsException, FileNotExistsException, CloudException, RecordNotExistsException, ProviderNotExistsException {
        LOGGER.info("Reading file headers in friendly way for: provider: {}, localId: {}, represenatation: {}, fileName: {}", new Object[]{providerId, localId, representationName, fileName});
        String cloudId = this.findCloudIdFor(providerId, localId);
        Representation representation = this.selectRepresentationVersion(cloudId, representationName);
        if (representation == null) {
            throw new RepresentationNotExistsException();
        }
        if (this.userHasRightsToReadFile(cloudId, representation.getRepresentationName(), representation.getVersion())) {
            File requestedFile = this.readFile(cloudId, representationName, representation.getVersion(), fileName);
            String md5 = requestedFile.getMd5();
            String fileMimeType = null;
            if (StringUtils.isNotBlank((String)requestedFile.getMimeType())) {
                fileMimeType = requestedFile.getMimeType();
            }
            EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation, (File)requestedFile);
            return Response.status((Response.Status)Response.Status.OK).type(fileMimeType).location(requestedFile.getContentUri()).tag(md5).build();
        }
        throw new AccessDeniedException("Access is denied");
    }

    private boolean userHasRightsToReadFile(String cloudId, String representationName, String representationVersion) {
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication authentication = ctx.getAuthentication();
        String targetId = cloudId + "/" + representationName + "/" + representationVersion;
        boolean hasAccess = this.permissionEvaluator.hasPermission(authentication, (Serializable)((Object)targetId), Representation.class.getName(), (Object)"read");
        return hasAccess;
    }

    private String findCloudIdFor(String providerID, String localId) throws CloudException, ProviderNotExistsException, RecordNotExistsException {
        CloudId foundCloudId = this.uisClientHandler.getCloudIdFromProviderAndLocalId(providerID, localId);
        return foundCloudId.getId();
    }

    private Representation selectRepresentationVersion(String cloudId, String representationName) throws RepresentationNotExistsException, RecordNotExistsException {
        List representations = this.recordService.listRepresentationVersions(cloudId, representationName);
        LatestPersistentRepresentationVersionSelector representationSelector = new LatestPersistentRepresentationVersionSelector();
        return representationSelector.select(representations);
    }

    private File readFile(String cloudId, String representationName, String version, String fileName) throws RepresentationNotExistsException, FileNotExistsException {
        return this.recordService.getFile(cloudId, representationName, version, fileName);
    }

    static /* synthetic */ RecordService access$000(SimplifiedFileAccessResource x0) {
        return x0.recordService;
    }
}

