/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations")
@Component
@Scope(value="request")
public class RepresentationsResource {
    @Autowired
    private RecordService recordService;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="java.util.List<eu.europeana.cloud.common.model.Representation>")
    public List<Representation> getRepresentations(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId) throws RecordNotExistsException {
        List representationInfos = this.recordService.getRecord(globalId).getRepresentations();
        this.prepare(uriInfo, representationInfos);
        return representationInfos;
    }

    private void prepare(UriInfo uriInfo, List<Representation> representationInfos) {
        for (Representation representationInfo : representationInfos) {
            representationInfo.setFiles(null);
            EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representationInfo);
        }
    }
}

