/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.aas.authentication.SpringUserUtils;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.CannotModifyPersistentRepresentationException;
import eu.europeana.cloud.service.mcs.exception.CannotPersistEmptyRepresentationException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}")
@Component
@Scope(value="request")
public class RepresentationVersionResource {
    @Autowired
    private RecordService recordService;
    @Autowired
    private MutableAclService mutableAclService;
    private final String REPRESENTATION_CLASS_NAME = Representation.class.getName();

    @GET
    @Produces(value={"application/xml", "application/json"})
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    @ReturnType(value="eu.europeana.cloud.common.model.Representation")
    public Representation getRepresentationVersion(@Context UriInfo uriInfo, @PathParam(value="VERSION") String version, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="CLOUDID") String globalId) throws RepresentationNotExistsException {
        Representation rep = this.recordService.getRepresentation(globalId, schema, version);
        this.prepare(uriInfo, rep);
        return rep;
    }

    @DELETE
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', delete)")
    public void deleteRepresentation(@PathParam(value="VERSION") String version, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="CLOUDID") String globalId) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException {
        this.recordService.deleteRepresentation(globalId, schema, version);
        ObjectIdentityImpl dataSetIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + version)));
        this.mutableAclService.deleteAcl((ObjectIdentity)dataSetIdentity, false);
    }

    @POST
    @Path(value="/persist")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    public Response persistRepresentation(@Context UriInfo uriInfo, @PathParam(value="VERSION") String version, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="CLOUDID") String globalId) throws RepresentationNotExistsException, CannotModifyPersistentRepresentationException, CannotPersistEmptyRepresentationException {
        Representation persistentVersion = this.recordService.persistRepresentation(globalId, schema, version);
        this.prepare(uriInfo, persistentVersion);
        return Response.created((URI)persistentVersion.getUri()).build();
    }

    @POST
    @Path(value="/copy")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', read)")
    public Response copyRepresentation(@Context UriInfo uriInfo, @PathParam(value="VERSION") String version, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="CLOUDID") String globalId) throws RepresentationNotExistsException {
        Representation copiedRep = this.recordService.copyRepresentation(globalId, schema, version);
        this.prepare(uriInfo, copiedRep);
        String copiedReprOwner = SpringUserUtils.getUsername();
        if (copiedReprOwner != null) {
            ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + copiedRep.getVersion())));
            MutableAcl versionAcl = this.mutableAclService.createAcl((ObjectIdentity)versionIdentity);
            versionAcl.insertAce(0, BasePermission.READ, (Sid)new PrincipalSid(copiedReprOwner), true);
            versionAcl.insertAce(1, BasePermission.WRITE, (Sid)new PrincipalSid(copiedReprOwner), true);
            versionAcl.insertAce(2, BasePermission.DELETE, (Sid)new PrincipalSid(copiedReprOwner), true);
            versionAcl.insertAce(3, BasePermission.ADMINISTRATION, (Sid)new PrincipalSid(copiedReprOwner), true);
            this.mutableAclService.updateAcl(versionAcl);
        }
        return Response.created((URI)copiedRep.getUri()).build();
    }

    private void prepare(UriInfo uriInfo, Representation representationVersion) {
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representationVersion);
    }
}

