/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.model.Permission;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.commons.permissions.PermissionsGrantingManager;
import eu.europeana.cloud.service.mcs.rest.ParamUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.ObjectIdentityImpl;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/versions/{VERSION}")
@Component
public class RepresentationAuthorizationResource {
    private static final List<String> acceptedPermissionValues = Arrays.asList(Permission.ALL.getValue(), Permission.READ.getValue(), Permission.WRITE.getValue(), Permission.ADMINISTRATION.getValue(), Permission.DELETE.getValue());
    @Autowired
    private MutableAclService mutableAclService;
    @Autowired
    private PermissionsGrantingManager permissionsGrantingManager;
    private final String REPRESENTATION_CLASS_NAME = Representation.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationAuthorizationResource.class);

    @DELETE
    @Path(value="/permissions/{permission}/users/{username}")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    public Response removePermissions(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="username") String userName, @PathParam(value="permission") String permission) {
        ParamUtil.require((String)"CLOUDID", (Object)globalId);
        ParamUtil.require((String)"REPRESENTATIONNAME", (Object)schema);
        ParamUtil.require((String)"VERSION", (Object)version);
        ParamUtil.require((String)"username", (Object)userName);
        ParamUtil.require((String)"permission", (Object)permission);
        ParamUtil.validate((String)"permission", (Object)permission, (List)acceptedPermissionValues);
        Permission _permission = Permission.valueOf((String)permission.toUpperCase());
        ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + version)));
        LOGGER.info("Removing privileges for user '{}' to  '{}' with key '{}'", new Object[]{userName, versionIdentity.getType(), versionIdentity.getIdentifier()});
        List<org.springframework.security.acls.model.Permission> permissionsToBeRemoved = Arrays.asList(_permission.getSpringPermissions());
        this.permissionsGrantingManager.removePermissions((ObjectIdentity)versionIdentity, userName, permissionsToBeRemoved);
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/permissions/{permission}/users/{username}")
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    public Response updateAuthorization(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version, @PathParam(value="username") String username, @PathParam(value="permission") String permission) {
        ParamUtil.require((String)"CLOUDID", (Object)globalId);
        ParamUtil.require((String)"REPRESENTATIONNAME", (Object)schema);
        ParamUtil.require((String)"VERSION", (Object)version);
        ParamUtil.require((String)"username", (Object)username);
        ParamUtil.require((String)"permission", (Object)permission);
        ParamUtil.validate((String)"permission", (Object)permission, (List)acceptedPermissionValues);
        ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + version)));
        Permission _permission = Permission.valueOf((String)permission.toUpperCase());
        MutableAcl versionAcl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)versionIdentity);
        if (versionAcl != null) {
            try {
                org.springframework.security.acls.model.Permission[] permissions;
                for (org.springframework.security.acls.model.Permission singlePermission : permissions = _permission.getSpringPermissions()) {
                    versionAcl.insertAce(versionAcl.getEntries().size(), singlePermission, (Sid)new PrincipalSid(username), true);
                }
                this.mutableAclService.updateAcl(versionAcl);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                return Response.notModified((String)"Authorization has NOT been updated!").build();
            }
            return Response.ok((Object)"Authorization has been updated!").build();
        }
        return Response.notModified((String)"Authorization has NOT been updated!").build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @PreAuthorize(value="hasPermission(#globalId.concat('/').concat(#schema).concat('/').concat(#version), 'eu.europeana.cloud.common.model.Representation', write)")
    @Path(value="/permit")
    public Response giveReadAccessToEveryone(@PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="VERSION") String version) {
        ObjectIdentityImpl versionIdentity = new ObjectIdentityImpl(this.REPRESENTATION_CLASS_NAME, (Serializable)((Object)(globalId + "/" + schema + "/" + version)));
        MutableAcl versionAcl = (MutableAcl)this.mutableAclService.readAclById((ObjectIdentity)versionIdentity);
        GrantedAuthoritySid anonRole = new GrantedAuthoritySid("ROLE_ANONYMOUS");
        GrantedAuthoritySid userRole = new GrantedAuthoritySid("ROLE_USER");
        if (versionAcl != null) {
            versionAcl.insertAce(versionAcl.getEntries().size(), BasePermission.READ, (Sid)anonRole, true);
            versionAcl.insertAce(versionAcl.getEntries().size(), BasePermission.READ, (Sid)userRole, true);
            this.mutableAclService.updateAcl(versionAcl);
            return Response.ok((Object)"Authorization has been updated!").build();
        }
        return Response.notModified((String)"Authorization has NOT been updated!").build();
    }
}

