/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest.storage.selector;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PreBufferedInputStream
extends BufferedInputStream {
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private final int bufferSize;
    private byte[] buffer;
    private int bufferFill;
    private int position;

    public static PreBufferedInputStream wrap(InputStream inputStream, int preloadChunkSize) {
        return new PreBufferedInputStream(inputStream, preloadChunkSize);
    }

    public PreBufferedInputStream(InputStream stream, int bufferSize) {
        super(stream, 1024);
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        try {
            this.fillBuffer();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void fillBuffer() throws IOException {
        this.ensureIsNotClosed();
        for (int i = 0; i < this.bufferSize; i += 1024) {
            int bufferLength = Math.min(this.bufferSize - this.bufferFill, 1024);
            byte[] bytes = new byte[bufferLength];
            int length = super.read(bytes, 0, bufferLength);
            if (length == -1) continue;
            System.arraycopy(bytes, 0, this.buffer, this.bufferFill, length);
            this.bufferFill += length;
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureIsNotClosed();
        if (this.position < this.bufferFill) {
            return this.buffer[this.position++] & 0xFF;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.ensureIsNotClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int result = this.readFromBufferAndStream(b, offset, length);
        return result;
    }

    private int readFromBufferAndStream(byte[] b, int off, int len) throws IOException {
        int offset = off;
        int length = len;
        int available = this.bufferFill - this.position;
        if (available > 0) {
            if (length < available) {
                available = length;
            }
            System.arraycopy(this.buffer, this.position, b, offset, available);
            this.position += available;
            offset += available;
            length -= available;
        }
        if (length > 0) {
            if ((length = super.read(b, offset, length)) == -1) {
                return available == 0 ? -1 : available;
            }
            return available + length;
        }
        return available;
    }

    @Override
    public int available() throws IOException {
        this.ensureIsNotClosed();
        int inBufferAvailable = this.bufferFill - this.position;
        int avail = super.available();
        return inBufferAvailable > Integer.MAX_VALUE - avail ? Integer.MAX_VALUE : inBufferAvailable + avail;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (readLimit > this.bufferSize) {
            throw new UnsupportedOperationException("Marking outside buffer is not supported!");
        }
        this.marklimit = readLimit;
        this.markpos = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.ensureIsNotClosed();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.position = this.markpos;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.in == null && this.buffer == null) {
            return;
        }
        this.buffer = null;
        this.in.close();
        this.in = null;
    }

    @Override
    public long skip(long length) throws IOException {
        this.ensureIsNotClosed();
        long skip = length;
        if (skip <= 0L) {
            return 0L;
        }
        long actualSkip = (long)this.bufferFill - (long)this.position;
        if (actualSkip > 0L) {
            if (skip < actualSkip) {
                actualSkip = skip;
            }
            this.position = (int)((long)this.position + actualSkip);
            skip -= actualSkip;
        }
        if (skip > 0L) {
            long currentSkip;
            do {
                currentSkip = super.skip(skip);
                actualSkip += currentSkip;
            } while (currentSkip > 0L && (skip -= currentSkip) > 0L);
        }
        return actualSkip;
    }

    private void ensureIsNotClosed() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }
}

