/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.client.uis.rest.CloudException;
import eu.europeana.cloud.common.model.CloudId;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.UISClientHandler;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RecordNotExistsException;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/records/{LOCALID:.+}/representations/{REPRESENTATIONNAME}")
@Component
@Scope(value="request")
public class SimplifiedRepresentationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplifiedRepresentationResource.class);
    @Autowired
    private UISClientHandler uisClientHandler;
    @Autowired
    private RecordService recordService;

    @GET
    @PostAuthorize(value="hasPermission(  (returnObject.cloudId).concat('/').concat(#representationName).concat('/').concat(returnObject.version) , 'eu.europeana.cloud.common.model.Representation', read)")
    public Representation getRepresentation(@Context UriInfo uriInfo, @PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="LOCALID") String localId, @PathParam(value="REPRESENTATIONNAME") String representationName) throws CloudException, RepresentationNotExistsException, ProviderNotExistsException, RecordNotExistsException {
        LOGGER.info("Reading representation '{}' using 'friendly' approach for providerId: {} and localId: {}", new Object[]{representationName, providerId, localId});
        String cloudId = this.findCloudIdFor(providerId, localId);
        Representation representation = this.recordService.getRepresentation(cloudId, representationName);
        EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation);
        return representation;
    }

    private String findCloudIdFor(String providerID, String localId) throws CloudException, ProviderNotExistsException, RecordNotExistsException {
        CloudId foundCloudId = this.uisClientHandler.getCloudIdFromProviderAndLocalId(providerID, localId);
        return foundCloudId.getId();
    }
}

