/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.common.response.RepresentationRevisionResponse;
import eu.europeana.cloud.service.mcs.RecordService;
import eu.europeana.cloud.service.mcs.exception.RepresentationNotExistsException;
import eu.europeana.cloud.service.mcs.rest.EnrichUriUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Path(value="/records/{CLOUDID}/representations/{REPRESENTATIONNAME}/revisions/{REVISION_NAME}")
@Component
@Scope(value="request")
public class RepresentationRevisionsResource {
    @Autowired
    private RecordService recordService;
    @Autowired
    private PermissionEvaluator permissionEvaluator;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="java.util.List<eu.europeana.cloud.common.model.Representation>")
    public List<Representation> getRepresentationRevisions(@Context UriInfo uriInfo, @PathParam(value="CLOUDID") String globalId, @PathParam(value="REPRESENTATIONNAME") String schema, @PathParam(value="REVISION_NAME") String revisionName, @QueryParam(value="revisionProviderId") String revisionProviderId, @QueryParam(value="revisionTimestamp") String revisionTimestamp) throws RepresentationNotExistsException {
        if (revisionProviderId == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorInfo("OTHER", "revisionProviderId parameter cannot be empty.")).build());
        }
        Date revisionDate = null;
        if (revisionTimestamp != null) {
            DateTime utc = new DateTime((Object)revisionTimestamp, DateTimeZone.UTC);
            revisionDate = utc.toDate();
        }
        List info = this.recordService.getRepresentationRevisions(globalId, schema, revisionProviderId, revisionName, revisionDate);
        ArrayList<Representation> representations = new ArrayList<Representation>();
        if (info != null) {
            for (RepresentationRevisionResponse representationRevisionsResource : info) {
                Representation representation = this.recordService.getRepresentation(representationRevisionsResource.getCloudId(), representationRevisionsResource.getRepresentationName(), representationRevisionsResource.getVersion());
                EnrichUriUtil.enrich((UriInfo)uriInfo, (Representation)representation);
                if (!this.userHasAccessTo(representation)) continue;
                representations.add(representation);
            }
        } else {
            throw new RepresentationNotExistsException("No representation was found");
        }
        return representations;
    }

    private boolean userHasAccessTo(Representation representation) {
        SecurityContext ctx = SecurityContextHolder.getContext();
        Authentication authentication = ctx.getAuthentication();
        String targetId = representation.getCloudId() + "/" + representation.getRepresentationName() + "/" + representation.getVersion();
        return this.permissionEvaluator.hasPermission(authentication, (Serializable)((Object)targetId), Representation.class.getName(), (Object)"read");
    }
}

