/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import eu.europeana.cloud.common.response.ErrorInfo;
import eu.europeana.cloud.service.mcs.status.McsErrorCode;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class ParamUtil {
    static void require(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            ErrorInfo errorInfo = new ErrorInfo(McsErrorCode.OTHER.name(), parameterName + " is a required parameter");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorInfo).build());
        }
    }

    static <T> void validate(String parameterName, T parameterValue, List<T> acceptedValues) {
        if (!acceptedValues.contains(parameterValue)) {
            ErrorInfo errorInfo = new ErrorInfo(McsErrorCode.OTHER.name(), parameterName + " has unsupported value");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorInfo).build());
        }
    }

    static void validateTags(Set<String> tags, Set<String> expectedTags) {
        if (!expectedTags.containsAll(tags)) {
            ErrorInfo errorInfo = new ErrorInfo(McsErrorCode.OTHER.name(), "The tags set was not validated !, The accepted tags are : " + expectedTags);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorInfo).build());
        }
    }

    private ParamUtil() {
    }
}

