/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.mcs.rest;

import com.qmino.miredot.annotations.ReturnType;
import eu.europeana.cloud.common.response.ResultSlice;
import eu.europeana.cloud.service.mcs.DataSetService;
import eu.europeana.cloud.service.mcs.exception.DataSetNotExistsException;
import eu.europeana.cloud.service.mcs.exception.ProviderNotExistsException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.stereotype.Component;

@Path(value="/data-providers/{DATAPROVIDER}/data-sets/{DATASET}/representations/{REPRESENTATIONNAME}/revisions/{REVISION_NAME}/revisionProvider/{REVISION_PROVIDER_ID}")
@Component
@Scope(value="request")
public class DataSetRevisionsResource {
    @Autowired
    private DataSetService dataSetService;
    @Value(value="${numberOfElementsOnPage}")
    private int numberOfElementsOnPage;
    @Autowired
    private MutableAclService mutableAclService;

    @GET
    @Produces(value={"application/xml", "application/json"})
    @ReturnType(value="eu.europeana.cloud.common.response.ResultSlice<CloudTagsResponse>")
    public Response getDataSetContents(@PathParam(value="DATAPROVIDER") String providerId, @PathParam(value="DATASET") String dataSetId, @PathParam(value="REPRESENTATIONNAME") String representationName, @PathParam(value="REVISION_NAME") String revisionName, @PathParam(value="REVISION_PROVIDER_ID") String revisionProviderId, @QueryParam(value="revisionTimestamp") String revisionTimestamp, @QueryParam(value="startFrom") String startFrom, @QueryParam(value="limit") int limitParam) throws DataSetNotExistsException, ProviderNotExistsException {
        int limitWithNextSlice;
        int n = limitWithNextSlice = limitParam > 0 && limitParam <= 10000 ? limitParam : this.numberOfElementsOnPage;
        if (revisionTimestamp == null) {
            throw new WebApplicationException("Revision timestamp parameter cannot be null");
        }
        DateTime timestamp = new DateTime((Object)revisionTimestamp, DateTimeZone.UTC);
        ResultSlice result = this.dataSetService.getDataSetsRevisions(providerId, dataSetId, revisionProviderId, revisionName, timestamp.toDate(), representationName, startFrom, limitWithNextSlice);
        return Response.ok((Object)result).build();
    }
}

